/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.dao.OrderPaymentDao;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentLog;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blOrderPaymentService")
public class OrderPaymentServiceImpl
implements OrderPaymentService {
    @Resource(name="blOrderPaymentDao")
    protected OrderPaymentDao paymentDao;

    @Override
    @Transactional(value="blTransactionManager")
    public OrderPayment save(OrderPayment payment) {
        return this.paymentDao.save(payment);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public PaymentTransaction save(PaymentTransaction transaction) {
        return this.paymentDao.save(transaction);
    }

    @Override
    public PaymentLog save(PaymentLog log) {
        return this.paymentDao.save(log);
    }

    @Override
    public OrderPayment readPaymentById(Long paymentId) {
        return this.paymentDao.readPaymentById(paymentId);
    }

    @Override
    public List<OrderPayment> readPaymentsForOrder(Order order) {
        return this.paymentDao.readPaymentsForOrder(order);
    }

    @Override
    public OrderPayment create() {
        return this.paymentDao.create();
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void delete(OrderPayment payment) {
        this.paymentDao.delete(payment);
    }

    @Override
    public PaymentLog createLog() {
        return this.paymentDao.createLog();
    }

    @Override
    public PaymentTransaction createTransaction() {
        PaymentTransaction returnItem = this.paymentDao.createTransaction();
        returnItem.setDate(SystemTime.asDate());
        return returnItem;
    }

    @Override
    public PaymentTransaction readTransactionById(Long transactionId) {
        return this.paymentDao.readTransactionById(transactionId);
    }
}

