/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.util.dao.ResourcePurgeDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blResourcePurgeDao")
public class ResourcePurgeDaoImpl
implements ResourcePurgeDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;

    @Override
    public List<Order> findCarts(String[] names, OrderStatus[] statuses, Date dateCreatedMinThreshold, Boolean isPreview) {
        TypedQuery<Order> query = this.buildCartQuery(names, statuses, dateCreatedMinThreshold, isPreview, Order.class);
        return query.getResultList();
    }

    @Override
    public List<Order> findCarts(String[] names, OrderStatus[] statuses, Date dateCreatedMinThreshold, Boolean isPreview, int startPos, int length) {
        TypedQuery<Order> query = this.buildCartQuery(names, statuses, dateCreatedMinThreshold, isPreview, Order.class);
        query.setFirstResult(startPos);
        query.setMaxResults(length);
        return query.getResultList();
    }

    @Override
    public Long findCartsCount(String[] names, OrderStatus[] statuses, Date dateCreatedMinThreshold, Boolean isPreview) {
        TypedQuery<Long> query = this.buildCartQuery(names, statuses, dateCreatedMinThreshold, isPreview, Long.class);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Customer> findCustomers(Date dateCreatedMinThreshold, Boolean registered, Boolean deactivated, Boolean isPreview) {
        TypedQuery<Customer> query = this.buildCustomerQuery(dateCreatedMinThreshold, registered, deactivated, isPreview, Customer.class);
        return query.getResultList();
    }

    @Override
    public List<Customer> findCustomers(Date dateCreatedMinThreshold, Boolean registered, Boolean deactivated, Boolean isPreview, int startPos, int length) {
        TypedQuery<Customer> query = this.buildCustomerQuery(dateCreatedMinThreshold, registered, deactivated, isPreview, Customer.class);
        query.setFirstResult(startPos);
        query.setMaxResults(length);
        return query.getResultList();
    }

    @Override
    public Long findCustomersCount(Date dateCreatedMinThreshold, Boolean registered, Boolean deactivated, Boolean isPreview) {
        TypedQuery<Long> query = this.buildCustomerQuery(dateCreatedMinThreshold, registered, deactivated, isPreview, Long.class);
        return (Long)query.getSingleResult();
    }

    protected <T> TypedQuery<T> buildCustomerQuery(Date dateCreatedMinThreshold, Boolean registered, Boolean deactivated, Boolean isPreview, Class<T> returnType) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(returnType);
        Root root = criteria.from(CustomerImpl.class);
        if (Long.class.equals(returnType)) {
            criteria.select((Selection)builder.count((Expression)root));
        } else {
            criteria.select((Selection)root);
        }
        Subquery subquery = criteria.subquery(Long.class);
        Root orderRoot = subquery.from(OrderImpl.class);
        subquery.select(builder.count((Expression)orderRoot));
        subquery.where((Expression)builder.equal((Expression)orderRoot.get("customer"), (Expression)root));
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        restrictions.add(builder.equal((Expression)subquery, (Object)0L));
        if (registered != null) {
            if (registered.booleanValue()) {
                restrictions.add(builder.isTrue(root.get("registered").as(Boolean.class)));
            } else {
                restrictions.add(builder.or((Expression)builder.isNull((Expression)root.get("registered")), (Expression)builder.isFalse(root.get("registered").as(Boolean.class))));
            }
        }
        if (deactivated != null) {
            if (deactivated.booleanValue()) {
                restrictions.add(builder.isTrue(root.get("deactivated").as(Boolean.class)));
            } else {
                restrictions.add(builder.or((Expression)builder.isNull((Expression)root.get("deactivated")), (Expression)builder.isFalse(root.get("deactivated").as(Boolean.class))));
            }
        }
        if (dateCreatedMinThreshold != null) {
            restrictions.add(builder.lessThan(root.get("auditable").get("dateCreated").as(Date.class), (Comparable)dateCreatedMinThreshold));
        }
        if (isPreview != null) {
            if (isPreview.booleanValue()) {
                restrictions.add(builder.isTrue(root.get("previewable").get("isPreview").as(Boolean.class)));
            } else {
                restrictions.add(builder.or((Expression)builder.isNull((Expression)root.get("previewable").get("isPreview")), (Expression)builder.isFalse(root.get("previewable").get("isPreview").as(Boolean.class))));
            }
        }
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        return this.em.createQuery(criteria);
    }

    protected <T> TypedQuery<T> buildCartQuery(String[] names, OrderStatus[] statuses, Date dateCreatedMinThreshold, Boolean isPreview, Class<T> returnType) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(returnType);
        Root root = criteria.from(OrderImpl.class);
        if (Long.class.equals(returnType)) {
            criteria.select((Selection)builder.count((Expression)root));
        } else {
            criteria.select((Selection)root);
        }
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        ArrayList<String> statusList = new ArrayList<String>();
        if (statuses != null) {
            for (OrderStatus status : statuses) {
                statusList.add(status.getType());
            }
        } else {
            statusList.add("IN_PROCESS");
        }
        restrictions.add(root.get("status").in(statusList));
        if (names != null) {
            restrictions.add(root.get("name").in(Arrays.asList(names)));
        }
        if (dateCreatedMinThreshold != null) {
            restrictions.add(builder.lessThan(root.get("auditable").get("dateCreated").as(Date.class), (Comparable)dateCreatedMinThreshold));
        }
        if (isPreview != null) {
            if (isPreview.booleanValue()) {
                restrictions.add(builder.isTrue(root.get("previewable").get("isPreview").as(Boolean.class)));
            } else {
                restrictions.add(builder.or((Expression)builder.isNull((Expression)root.get("previewable").get("isPreview")), (Expression)builder.isFalse(root.get("previewable").get("isPreview").as(Boolean.class))));
            }
        }
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        return this.em.createQuery(criteria);
    }
}

