/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.exception.SiteMapException;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.SiteMapGeneratorTest;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapChangeFreqType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapPriorityType;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategorySiteMapGeneratorConfigurationImpl;
import org.broadleafcommerce.core.catalog.service.CategorySiteMapGenerator;
import org.easymock.EasyMock;
import org.junit.Test;

public class CategorySiteMapGeneratorTest
extends SiteMapGeneratorTest {
    @Test
    public void testCategorySiteMapGenerator() throws SiteMapException, IOException {
        CategoryImpl rootCategory = new CategoryImpl();
        CategoryImpl c1 = new CategoryImpl();
        c1.setUrl("/");
        c1.setDefaultParentCategory((Category)rootCategory);
        CategoryImpl c2 = new CategoryImpl();
        c2.setUrl("/hot-sauces");
        c2.setDefaultParentCategory((Category)rootCategory);
        CategoryImpl c3 = new CategoryImpl();
        c3.setUrl("merchandise");
        c3.setDefaultParentCategory((Category)rootCategory);
        CategoryImpl c4 = new CategoryImpl();
        c4.setUrl("/clearance");
        c4.setDefaultParentCategory((Category)rootCategory);
        ArrayList<CategoryImpl> categories = new ArrayList<CategoryImpl>();
        categories.add(c1);
        categories.add(c2);
        categories.add(c3);
        categories.add(c4);
        CategoryDao categoryDao = (CategoryDao)EasyMock.createMock(CategoryDao.class);
        EasyMock.expect((Object)categoryDao.readActiveSubCategoriesByCategory((Category)rootCategory, 5, 0)).andReturn(categories).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{categoryDao});
        CategorySiteMapGenerator csmg = new CategorySiteMapGenerator();
        csmg.setCategoryDao(categoryDao);
        csmg.setRowLimit(5);
        CategorySiteMapGeneratorConfigurationImpl smgc = new CategorySiteMapGeneratorConfigurationImpl();
        smgc.setDisabled(Boolean.valueOf(false));
        smgc.setSiteMapGeneratorType(SiteMapGeneratorType.CATEGORY);
        smgc.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        smgc.setSiteMapPriority(SiteMapPriorityType.POINT5);
        smgc.setRootCategory((Category)rootCategory);
        smgc.setStartingDepth(1);
        smgc.setEndingDepth(1);
        this.testGenerator((SiteMapGeneratorConfiguration)smgc, (SiteMapGenerator)csmg);
        File file1 = this.fileService.getResource("/sitemap_index.xml");
        File file2 = this.fileService.getResource("/sitemap1.xml");
        File file3 = this.fileService.getResource("/sitemap2.xml");
        this.compareFiles(file1, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap_index.xml");
        this.compareFiles(file2, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap1.xml");
        this.compareFiles(file3, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap2.xml");
        this.testGenerator((SiteMapGeneratorConfiguration)smgc, (SiteMapGenerator)csmg, 50000);
        File file4 = this.fileService.getResource("/sitemap.xml");
        this.compareFiles(file4, "src/test/resources/org/broadleafcommerce/sitemap/category/sitemap.xml");
    }
}

