/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfigurationImpl;
import org.broadleafcommerce.common.sitemap.exception.SiteMapException;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.SiteMapGeneratorTest;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapChangeFreqType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapPriorityType;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.service.ProductSiteMapGenerator;
import org.easymock.EasyMock;
import org.junit.Test;

public class ProductSiteMapGeneratorTest
extends SiteMapGeneratorTest {
    @Test
    public void testProductSiteMapGenerator() throws SiteMapException, IOException {
        ProductImpl p1 = new ProductImpl();
        p1.setUrl("/hot-sauces/sudden_death_sauce");
        ProductImpl p2 = new ProductImpl();
        p2.setUrl("hot-sauces/sweet_death_sauce");
        ProductImpl p3 = new ProductImpl();
        p3.setUrl("/hot-sauces/hoppin_hot_sauce");
        ProductImpl p4 = new ProductImpl();
        p4.setUrl("/hot-sauces/day_of_the_dead_chipotle_hot_sauce");
        ArrayList<ProductImpl> products = new ArrayList<ProductImpl>();
        products.add(p1);
        products.add(p2);
        products.add(p3);
        products.add(p4);
        ProductDao productDao = (ProductDao)EasyMock.createMock(ProductDao.class);
        EasyMock.expect((Object)productDao.readAllActiveProducts(EasyMock.eq((int)0), EasyMock.eq((int)5))).andReturn(products);
        EasyMock.replay((Object[])new Object[]{productDao});
        ProductSiteMapGenerator psmg = new ProductSiteMapGenerator();
        psmg.setProductDao(productDao);
        psmg.setPageSize(5);
        SiteMapGeneratorConfigurationImpl smgc = new SiteMapGeneratorConfigurationImpl();
        smgc.setDisabled(Boolean.valueOf(false));
        smgc.setSiteMapGeneratorType(SiteMapGeneratorType.PRODUCT);
        smgc.setSiteMapChangeFreq(SiteMapChangeFreqType.HOURLY);
        smgc.setSiteMapPriority(SiteMapPriorityType.POINT5);
        this.testGenerator((SiteMapGeneratorConfiguration)smgc, (SiteMapGenerator)psmg);
        File file1 = this.fileService.getResource("/sitemap_index.xml");
        File file2 = this.fileService.getResource("/sitemap1.xml");
        File file3 = this.fileService.getResource("/sitemap2.xml");
        this.compareFiles(file1, "src/test/resources/org/broadleafcommerce/sitemap/product/sitemap_index.xml");
        this.compareFiles(file2, "src/test/resources/org/broadleafcommerce/sitemap/product/sitemap1.xml");
        this.compareFiles(file3, "src/test/resources/org/broadleafcommerce/sitemap/product/sitemap2.xml");
    }
}

