/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.List;
import java.util.Map;
import org.broadleafcommerce.common.structure.dto.ItemCriteriaDTO;
import org.broadleafcommerce.common.structure.dto.StructuredContentDTO;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.AbstractCartRuleProcessor;
import org.broadleafcommerce.profile.core.domain.Customer;

public class StructuredContentCartRuleProcessor
extends AbstractCartRuleProcessor<StructuredContentDTO> {
    public boolean checkForMatch(StructuredContentDTO sc, Map<String, Object> valueMap) {
        List itemCriterias = sc.getItemCriteriaDTOList();
        if (itemCriterias != null && itemCriterias.size() > 0) {
            Order order = this.lookupOrderForCustomer((Customer)valueMap.get("customer"));
            if (order == null || order.getOrderItems() == null || order.getOrderItems().size() < 1) {
                return false;
            }
            for (ItemCriteriaDTO itemCriteria : itemCriterias) {
                if (this.checkItemCriteria(itemCriteria, order.getOrderItems())) continue;
                return false;
            }
        }
        return true;
    }
}

