/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.payment.dao.SecureOrderPaymentDao;
import org.broadleafcommerce.core.payment.domain.secure.BankAccountPayment;
import org.broadleafcommerce.core.payment.domain.secure.CreditCardPayment;
import org.broadleafcommerce.core.payment.domain.secure.GiftCardPayment;
import org.broadleafcommerce.core.payment.domain.secure.Referenced;
import org.springframework.stereotype.Repository;

@Repository(value="blSecureOrderPaymentDao")
public class SecureOrderPaymentDaoImpl
implements SecureOrderPaymentDao {
    @PersistenceContext(unitName="blSecurePU")
    protected EntityManager em;
    @Resource(name="blEncryptionModule")
    protected EncryptionModule encryptionModule;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Referenced save(Referenced securePaymentInfo) {
        return (Referenced)this.em.merge((Object)securePaymentInfo);
    }

    @Override
    public BankAccountPayment createBankAccountPayment() {
        BankAccountPayment response = (BankAccountPayment)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.BankAccountPaymentInfo");
        response.setEncryptionModule(this.encryptionModule);
        return response;
    }

    @Override
    public GiftCardPayment createGiftCardPayment() {
        GiftCardPayment response = (GiftCardPayment)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfo");
        response.setEncryptionModule(this.encryptionModule);
        return response;
    }

    @Override
    public CreditCardPayment createCreditCardPayment() {
        CreditCardPayment response = (CreditCardPayment)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo");
        response.setEncryptionModule(this.encryptionModule);
        return response;
    }

    @Override
    public BankAccountPayment findBankAccountPayment(String referenceNumber) {
        BankAccountPayment response;
        Query query = this.em.createNamedQuery("BC_READ_BANK_ACCOUNT_BY_REFERENCE_NUMBER");
        query.setParameter("referenceNumber", (Object)referenceNumber);
        List infos = query.getResultList();
        BankAccountPayment bankAccountPayment = response = infos == null || infos.size() == 0 ? null : (BankAccountPayment)infos.get(0);
        if (response != null) {
            response.setEncryptionModule(this.encryptionModule);
        }
        return response;
    }

    @Override
    public CreditCardPayment findCreditCardPayment(String referenceNumber) {
        CreditCardPayment response;
        Query query = this.em.createNamedQuery("BC_READ_CREDIT_CARD_BY_REFERENCE_NUMBER");
        query.setParameter("referenceNumber", (Object)referenceNumber);
        List infos = query.getResultList();
        CreditCardPayment creditCardPayment = response = infos == null || infos.size() == 0 ? null : (CreditCardPayment)infos.get(0);
        if (response != null) {
            response.setEncryptionModule(this.encryptionModule);
        }
        return response;
    }

    @Override
    public GiftCardPayment findGiftCardPayment(String referenceNumber) {
        GiftCardPayment response;
        Query query = this.em.createNamedQuery("BC_READ_GIFT_CARD_BY_REFERENCE_NUMBER");
        query.setParameter("referenceNumber", (Object)referenceNumber);
        List infos = query.getResultList();
        GiftCardPayment giftCardPayment = response = infos == null || infos.size() == 0 ? null : (GiftCardPayment)infos.get(0);
        if (response != null) {
            response.setEncryptionModule(this.encryptionModule);
        }
        return response;
    }

    @Override
    public void delete(Referenced securePayment) {
        if (!this.em.contains((Object)securePayment)) {
            securePayment = (Referenced)this.em.find(securePayment.getClass(), (Object)securePayment.getId());
        }
        this.em.remove((Object)securePayment);
    }
}

