/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.fulfillment.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentBand;
import org.broadleafcommerce.core.order.service.type.FulfillmentBandResultAmountType;

@MappedSuperclass
public abstract class FulfillmentBandImpl
implements FulfillmentBand {
    private static final long serialVersionUID = 1L;
    @Column(name="RESULT_AMOUNT", precision=19, scale=5, nullable=false)
    protected BigDecimal resultAmount;
    @Column(name="RESULT_AMOUNT_TYPE", nullable=false)
    @AdminPresentation(friendlyName="Result Type", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentBandResultAmountType")
    protected String resultAmountType = FulfillmentBandResultAmountType.RATE.getType();

    @Override
    public BigDecimal getResultAmount() {
        return this.resultAmount;
    }

    @Override
    public void setResultAmount(BigDecimal resultAmount) {
        this.resultAmount = resultAmount;
    }

    @Override
    public FulfillmentBandResultAmountType getResultAmountType() {
        return FulfillmentBandResultAmountType.getInstance(this.resultAmountType);
    }

    @Override
    public void setResultAmountType(FulfillmentBandResultAmountType resultAmountType) {
        this.resultAmountType = resultAmountType.getType();
    }
}

