/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionHandler;
import org.broadleafcommerce.core.offer.service.OfferServiceUtilities;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.processor.AbstractBaseProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.springframework.stereotype.Service;

@Service(value="blOrderOfferProcessor")
public class OrderOfferProcessorImpl
extends AbstractBaseProcessor
implements OrderOfferProcessor {
    private static final Log LOG = LogFactory.getLog(OrderOfferProcessorImpl.class);
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;
    @Resource(name="blOrderItemDao")
    protected OrderItemDao orderItemDao;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blOfferServiceUtilities")
    protected OfferServiceUtilities offerServiceUtilities;

    @Override
    public void filterOrderLevelOffer(PromotableOrder promotableOrder, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidatePromotionItems candidates;
        boolean orderLevelQualification;
        block6: {
            if (offer.getDiscountType().getType().equals(OfferDiscountType.FIX_PRICE.getType())) {
                LOG.warn((Object)("Offers of type ORDER may not have a discount type of FIX_PRICE. Ignoring order offer (name=" + offer.getName() + ")"));
                return;
            }
            orderLevelQualification = false;
            if (this.couldOfferApplyToOrder(offer, promotableOrder)) {
                orderLevelQualification = true;
            } else {
                for (PromotableOrderItem orderItem : promotableOrder.getDiscountableOrderItems(offer.getApplyDiscountToSalePrice())) {
                    if (!this.couldOfferApplyToOrder(offer, promotableOrder, orderItem)) continue;
                    orderLevelQualification = true;
                    break block6;
                }
                for (PromotableFulfillmentGroup fulfillmentGroup : promotableOrder.getFulfillmentGroups()) {
                    if (!this.couldOfferApplyToOrder(offer, promotableOrder, fulfillmentGroup)) continue;
                    orderLevelQualification = true;
                    break;
                }
            }
        }
        if (orderLevelQualification && (candidates = this.couldOfferApplyToOrderItems(offer, promotableOrder.getDiscountableOrderItems(offer.getApplyDiscountToSalePrice()))).isMatchedQualifier()) {
            PromotableCandidateOrderOffer candidateOffer = this.createCandidateOrderOffer(promotableOrder, qualifiedOrderOffers, offer);
            candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
        }
    }

    @Override
    public boolean couldOfferApplyToOrder(Offer offer, PromotableOrder promotableOrder) {
        return this.couldOfferApplyToOrder(offer, promotableOrder, null, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder promotableOrder, PromotableOrderItem orderItem) {
        return this.couldOfferApplyToOrder(offer, promotableOrder, orderItem, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder promotableOrder, PromotableFulfillmentGroup fulfillmentGroup) {
        return this.couldOfferApplyToOrder(offer, promotableOrder, null, fulfillmentGroup);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder promotableOrder, PromotableOrderItem promotableOrderItem, PromotableFulfillmentGroup promotableFulfillmentGroup) {
        boolean appliesToItem = false;
        String rule = null;
        if (offer.getAppliesToOrderRules() != null && offer.getAppliesToOrderRules().trim().length() != 0) {
            rule = offer.getAppliesToOrderRules();
        } else {
            OfferRule orderRule = offer.getOfferMatchRules().get(OfferRuleType.ORDER.getType());
            if (orderRule != null) {
                rule = orderRule.getMatchRule();
            }
        }
        if (rule != null) {
            Boolean expressionOutcome;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            promotableOrder.updateRuleVariables(vars);
            vars.put("offer", offer);
            if (promotableFulfillmentGroup != null) {
                promotableFulfillmentGroup.updateRuleVariables(vars);
            }
            if (promotableOrderItem != null) {
                promotableOrderItem.updateRuleVariables(vars);
            }
            if ((expressionOutcome = this.executeExpression(rule, vars)) != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected PromotableCandidateOrderOffer createCandidateOrderOffer(PromotableOrder promotableOrder, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        PromotableCandidateOrderOffer promotableCandidateOrderOffer = this.promotableItemFactory.createPromotableCandidateOrderOffer(promotableOrder, offer);
        qualifiedOrderOffers.add(promotableCandidateOrderOffer);
        return promotableCandidateOrderOffer;
    }

    @Override
    public List<PromotableCandidateOrderOffer> removeTrailingNotCombinableOrderOffers(List<PromotableCandidateOrderOffer> candidateOffers) {
        ArrayList<PromotableCandidateOrderOffer> remainingCandidateOffers = new ArrayList<PromotableCandidateOrderOffer>();
        int offerCount = 0;
        for (PromotableCandidateOrderOffer candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else {
                boolean treatAsNewFormat = false;
                if (candidateOffer.getOffer().getTreatAsNewFormat() != null && candidateOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                    treatAsNewFormat = true;
                }
                if (!treatAsNewFormat && candidateOffer.getOffer().isCombinableWithOtherOffers() || treatAsNewFormat && (candidateOffer.getOffer().isTotalitarianOffer() == null || !candidateOffer.getOffer().isTotalitarianOffer().booleanValue())) {
                    remainingCandidateOffers.add(candidateOffer);
                }
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }

    @Override
    public void applyAllOrderOffers(List<PromotableCandidateOrderOffer> orderOffers, PromotableOrder promotableOrder) {
        for (PromotableCandidateOrderOffer orderOffer : orderOffers) {
            if (!promotableOrder.canApplyOrderOffer(orderOffer)) continue;
            this.applyOrderOffer(promotableOrder, orderOffer);
            if (orderOffer.isTotalitarian() || promotableOrder.isTotalitarianItemOfferApplied()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Totalitarian Order Offer Applied.   Comparing order and item offers for best outcome.");
                }
                this.compareAndAdjustOrderAndItemOffers(promotableOrder);
                continue;
            }
            if (orderOffer.isCombinable()) continue;
            if (!LOG.isTraceEnabled()) break;
            LOG.trace((Object)("Non-Combinable Order Offer Applied with id=[" + orderOffer.getOffer().getId() + "].  No other order offers can be applied"));
            break;
        }
        promotableOrder.getOrder().setSubTotal(promotableOrder.calculateSubtotalWithAdjustments());
    }

    protected void compareAndAdjustOrderAndItemOffers(PromotableOrder promotableOrder) {
        Money itemAdjustmentTotal;
        Money orderAdjustmentTotal = promotableOrder.calculateOrderAdjustmentTotal();
        if (orderAdjustmentTotal.greaterThanOrEqual(itemAdjustmentTotal = promotableOrder.calculateItemAdjustmentTotal())) {
            promotableOrder.removeAllCandidateItemOfferAdjustments();
        } else {
            promotableOrder.removeAllCandidateOrderOfferAdjustments();
        }
    }

    protected void applyOrderOffer(PromotableOrder promotableOrder, PromotableCandidateOrderOffer orderOffer) {
        PromotableOrderAdjustment promotableOrderAdjustment = this.promotableItemFactory.createPromotableOrderAdjustment(orderOffer, promotableOrder);
        promotableOrder.addCandidateOrderAdjustment(promotableOrderAdjustment);
    }

    @Override
    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    @Override
    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }

    protected Map<Long, PromotableOrderAdjustment> buildPromotableOrderAdjustmentsMap(PromotableOrder promotableOrder) {
        HashMap<Long, PromotableOrderAdjustment> adjustmentsMap = new HashMap<Long, PromotableOrderAdjustment>();
        for (PromotableOrderAdjustment adjustment : promotableOrder.getCandidateOrderAdjustments()) {
            adjustmentsMap.put(adjustment.getOffer().getId(), adjustment);
        }
        return adjustmentsMap;
    }

    protected void synchronizeOrderAdjustments(PromotableOrder promotableOrder) {
        Order order = promotableOrder.getOrder();
        if (order.getOrderAdjustments().isEmpty() && promotableOrder.getCandidateOrderAdjustments().isEmpty()) {
            return;
        }
        Map<Long, PromotableOrderAdjustment> newAdjustmentsMap = this.buildPromotableOrderAdjustmentsMap(promotableOrder);
        Iterator<OrderAdjustment> orderAdjIterator = order.getOrderAdjustments().iterator();
        while (orderAdjIterator.hasNext()) {
            OrderAdjustment adjustment = orderAdjIterator.next();
            if (adjustment.getOffer() == null) continue;
            Long offerId = adjustment.getOffer().getId();
            PromotableOrderAdjustment promotableAdjustment = newAdjustmentsMap.remove(offerId);
            if (promotableAdjustment != null) {
                if (adjustment.getValue().equals((Object)promotableAdjustment.getAdjustmentValue())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating value for order adjustment with offer Id " + offerId + " to " + promotableAdjustment.getAdjustmentValue()));
                }
                adjustment.setValue(promotableAdjustment.getAdjustmentValue());
                continue;
            }
            orderAdjIterator.remove();
        }
        for (PromotableOrderAdjustment promotableOrderAdjustment : newAdjustmentsMap.values()) {
            Offer offer = promotableOrderAdjustment.getOffer();
            OrderAdjustment orderAdjustment = this.offerDao.createOrderAdjustment();
            orderAdjustment.init(order, offer, offer.getName());
            orderAdjustment.setValue(promotableOrderAdjustment.getAdjustmentValue());
            order.getOrderAdjustments().add(orderAdjustment);
        }
    }

    protected void synchronizeOrderItems(PromotableOrder promotableOrder) {
        Order order = promotableOrder.getOrder();
        Map<OrderItem, PromotableOrderItem> promotableItemMap = this.offerServiceUtilities.buildPromotableItemMap(promotableOrder);
        List<OrderItem> orderItemList = this.offerServiceUtilities.buildOrderItemList(order);
        for (OrderItem orderItem : orderItemList) {
            PromotableOrderItem promotableItem = promotableItemMap.get(orderItem);
            if (promotableItem == null) continue;
            this.synchronizeItemPriceDetails(orderItem, promotableItem);
            this.synchronizeItemQualifiers(orderItem, promotableItem);
        }
    }

    protected void synchronizeItemPriceDetails(OrderItem orderItem, PromotableOrderItem promotableOrderItem) {
        Map<String, PromotableOrderItemPriceDetail> promotableDetailsMap = this.buildPromotableDetailsMap(promotableOrderItem);
        HashMap<Long, OrderItemPriceDetail> unmatchedDetailsMap = new HashMap<Long, OrderItemPriceDetail>();
        for (OrderItemPriceDetail orderItemPriceDetail : orderItem.getOrderItemPriceDetails()) {
            String detailKey = this.buildItemPriceDetailKey(orderItemPriceDetail);
            PromotableOrderItemPriceDetail promotableDetail = promotableDetailsMap.remove(detailKey);
            if (promotableDetail != null) {
                this.processMatchingDetails(orderItemPriceDetail, promotableDetail);
                continue;
            }
            unmatchedDetailsMap.put(orderItemPriceDetail.getId(), orderItemPriceDetail);
        }
        Iterator unmatchedDetailsIterator = unmatchedDetailsMap.values().iterator();
        for (PromotableOrderItemPriceDetail priceDetail : promotableDetailsMap.values()) {
            if (unmatchedDetailsIterator.hasNext()) {
                OrderItemPriceDetail existingDetail = (OrderItemPriceDetail)unmatchedDetailsIterator.next();
                existingDetail.setUseSalePrice(true);
                this.offerServiceUtilities.updatePriceDetail(existingDetail, priceDetail);
                unmatchedDetailsIterator.remove();
                continue;
            }
            OrderItemPriceDetail newPriceDetail = this.orderItemDao.createOrderItemPriceDetail();
            newPriceDetail.setOrderItem(orderItem);
            this.offerServiceUtilities.updatePriceDetail(newPriceDetail, priceDetail);
            orderItem.getOrderItemPriceDetails().add(newPriceDetail);
        }
        Iterator<OrderItemPriceDetail> pdIterator = orderItem.getOrderItemPriceDetails().iterator();
        this.offerServiceUtilities.removeUnmatchedPriceDetails(unmatchedDetailsMap, pdIterator);
    }

    protected void synchronizeItemQualifiers(OrderItem orderItem, PromotableOrderItem promotableOrderItem) {
        Map<Long, PromotionQualifier> qualifiersMap = this.buildPromotableQualifiersMap(promotableOrderItem);
        HashMap<Long, OrderItemQualifier> unmatchedQualifiersMap = new HashMap<Long, OrderItemQualifier>();
        for (OrderItemQualifier orderItemQualifier : orderItem.getOrderItemQualifiers()) {
            PromotionQualifier promotableQualifier = qualifiersMap.remove(orderItemQualifier.getOffer().getId());
            if (promotableQualifier != null) {
                if (orderItemQualifier.getQuantity() == (long)promotableQualifier.getQuantity()) continue;
                orderItemQualifier.setQuantity(new Long(promotableQualifier.getQuantity()));
                continue;
            }
            unmatchedQualifiersMap.put(orderItemQualifier.getId(), orderItemQualifier);
        }
        Iterator unmatchedQualifiersIterator = unmatchedQualifiersMap.values().iterator();
        for (PromotionQualifier qualifier : qualifiersMap.values()) {
            if (unmatchedQualifiersIterator.hasNext()) {
                OrderItemQualifier existingQualifier = (OrderItemQualifier)unmatchedQualifiersIterator.next();
                existingQualifier.setOffer(qualifier.getPromotion());
                existingQualifier.setQuantity(Long.valueOf(qualifier.getQuantity()));
                unmatchedQualifiersIterator.remove();
                continue;
            }
            OrderItemQualifier newQualifier = this.orderItemDao.createOrderItemQualifier();
            newQualifier.setOrderItem(orderItem);
            newQualifier.setOffer(qualifier.getPromotion());
            newQualifier.setQuantity(Long.valueOf(qualifier.getQuantity()));
            orderItem.getOrderItemQualifiers().add(newQualifier);
        }
        Iterator<OrderItemQualifier> qIterator = orderItem.getOrderItemQualifiers().iterator();
        this.offerServiceUtilities.removeUnmatchedQualifiers(unmatchedQualifiersMap, qIterator);
    }

    protected void processMatchingDetails(OrderItemPriceDetail itemDetail, PromotableOrderItemPriceDetail promotableItemDetail) {
        Map<Long, OrderItemPriceDetailAdjustment> itemAdjustmentMap = this.offerServiceUtilities.buildItemDetailAdjustmentMap(itemDetail);
        if (itemDetail.getQuantity() != promotableItemDetail.getQuantity()) {
            itemDetail.setQuantity(promotableItemDetail.getQuantity());
        }
        for (PromotableOrderItemPriceDetailAdjustment adjustment : promotableItemDetail.getCandidateItemAdjustments()) {
            OrderItemPriceDetailAdjustment itemAdjustment = itemAdjustmentMap.get(adjustment.getOfferId());
            if (itemAdjustment.getValue().equals((Object)adjustment.getAdjustmentValue())) continue;
            itemAdjustment.setValue(adjustment.getAdjustmentValue());
            itemAdjustment.setAppliedToSalePrice(adjustment.isAppliedToSalePrice());
        }
    }

    protected String buildItemPriceDetailKey(OrderItemPriceDetail itemDetail) {
        ArrayList<Long> offerIds = new ArrayList<Long>();
        for (OrderItemPriceDetailAdjustment adjustment : itemDetail.getOrderItemPriceDetailAdjustments()) {
            Long offerId = adjustment.getOffer().getId();
            offerIds.add(offerId);
        }
        Collections.sort(offerIds);
        return itemDetail.getOrderItem().toString() + ((Object)offerIds).toString() + itemDetail.getUseSalePrice();
    }

    protected Map<String, PromotableOrderItemPriceDetail> buildPromotableDetailsMap(PromotableOrderItem item) {
        HashMap<String, PromotableOrderItemPriceDetail> detailsMap = new HashMap<String, PromotableOrderItemPriceDetail>();
        for (PromotableOrderItemPriceDetail detail : item.getPromotableOrderItemPriceDetails()) {
            detailsMap.put(detail.buildDetailKey(), detail);
        }
        return detailsMap;
    }

    protected Map<Long, PromotionQualifier> buildPromotableQualifiersMap(PromotableOrderItem item) {
        HashMap<Long, PromotionQualifier> qualifiersMap = new HashMap<Long, PromotionQualifier>();
        for (PromotableOrderItemPriceDetail detail : item.getPromotableOrderItemPriceDetails()) {
            for (PromotionQualifier qualifier : detail.getPromotionQualifiers()) {
                PromotionQualifier existingQualifier = (PromotionQualifier)qualifiersMap.get(qualifier.getPromotion().getId());
                if (existingQualifier != null) {
                    existingQualifier.setQuantity(existingQualifier.getQuantity() + qualifier.getQuantity());
                    continue;
                }
                qualifiersMap.put(qualifier.getPromotion().getId(), qualifier);
            }
        }
        return qualifiersMap;
    }

    protected void synchronizeFulfillmentGroups(PromotableOrder promotableOrder) {
        Order order = promotableOrder.getOrder();
        Map<Long, PromotableFulfillmentGroup> fgMap = this.buildPromotableFulfillmentGroupMap(promotableOrder);
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            this.synchronizeFulfillmentGroupAdjustments(fg, fgMap.get(fg.getId()));
        }
    }

    protected Map<Long, PromotableFulfillmentGroup> buildPromotableFulfillmentGroupMap(PromotableOrder order) {
        HashMap<Long, PromotableFulfillmentGroup> fgMap = new HashMap<Long, PromotableFulfillmentGroup>();
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgMap.put(fg.getFulfillmentGroup().getId(), fg);
        }
        return fgMap;
    }

    protected Map<Long, PromotableFulfillmentGroupAdjustment> buildPromFulfillmentAdjMap(PromotableFulfillmentGroup fg) {
        HashMap<Long, PromotableFulfillmentGroupAdjustment> fgMap = new HashMap<Long, PromotableFulfillmentGroupAdjustment>();
        for (PromotableFulfillmentGroupAdjustment adjustment : fg.getCandidateFulfillmentGroupAdjustments()) {
            fgMap.put(adjustment.getPromotableCandidateFulfillmentGroupOffer().getOffer().getId(), adjustment);
        }
        return fgMap;
    }

    protected void synchronizeFulfillmentGroupAdjustments(FulfillmentGroup fg, PromotableFulfillmentGroup promotableFG) {
        Iterator<FulfillmentGroupAdjustment> adjustmentIterator = fg.getFulfillmentGroupAdjustments().iterator();
        Map<Long, PromotableFulfillmentGroupAdjustment> promotableAdjMap = this.buildPromFulfillmentAdjMap(promotableFG);
        while (adjustmentIterator.hasNext()) {
            FulfillmentGroupAdjustment currentAdj = adjustmentIterator.next();
            PromotableFulfillmentGroupAdjustment newAdj = promotableAdjMap.remove(currentAdj.getOffer().getId());
            if (newAdj != null) {
                if (currentAdj.getValue().equals((Object)newAdj.getAdjustmentValue())) continue;
                currentAdj.setValue(newAdj.getAdjustmentValue());
                continue;
            }
            adjustmentIterator.remove();
        }
        for (PromotableFulfillmentGroupAdjustment newAdj : promotableAdjMap.values()) {
            FulfillmentGroupAdjustment fa = this.offerDao.createFulfillmentGroupAdjustment();
            fa.setFulfillmentGroup(fg);
            fa.init(fg, newAdj.getPromotableCandidateFulfillmentGroupOffer().getOffer(), null);
            fa.setValue(newAdj.getAdjustmentValue());
            fg.getFulfillmentGroupAdjustments().add(fa);
        }
    }

    @Override
    public void synchronizeAdjustmentsAndPrices(PromotableOrder promotableOrder) {
        this.synchronizeOrderAdjustments(promotableOrder);
        this.synchronizeOrderItems(promotableOrder);
        if (this.extensionManager != null) {
            ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).synchronizeAdjustmentsAndPrices(promotableOrder);
        }
        this.synchronizeFulfillmentGroups(promotableOrder);
    }

    @Override
    public void setOfferDao(OfferDao offerDao) {
        this.offerDao = offerDao;
    }

    @Override
    public void setOrderItemDao(OrderItemDao orderItemDao) {
        this.orderItemDao = orderItemDao;
    }

    public OfferServiceUtilities getOfferServiceUtilities() {
        return this.offerServiceUtilities;
    }

    public void setOfferServiceUtilities(OfferServiceUtilities offerServiceUtilities) {
        this.offerServiceUtilities = offerServiceUtilities;
    }
}

