/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Address;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blFulfillmentGroupService")
public class FulfillmentGroupServiceImpl
implements FulfillmentGroupService {
    @Resource(name="blFulfillmentGroupDao")
    protected FulfillmentGroupDao fulfillmentGroupDao;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;

    @Override
    @Transactional(value="blTransactionManager")
    public FulfillmentGroup save(FulfillmentGroup fulfillmentGroup) {
        if (fulfillmentGroup.getSequence() == null) {
            fulfillmentGroup.setSequence(this.fulfillmentGroupDao.readNextFulfillmentGroupSequnceForOrder(fulfillmentGroup.getOrder()));
        }
        return this.fulfillmentGroupDao.save(fulfillmentGroup);
    }

    @Override
    public FulfillmentGroup createEmptyFulfillmentGroup() {
        return this.fulfillmentGroupDao.create();
    }

    @Override
    public FulfillmentGroup findFulfillmentGroupById(Long fulfillmentGroupId) {
        return this.fulfillmentGroupDao.readFulfillmentGroupById(fulfillmentGroupId);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void delete(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroupDao.delete(fulfillmentGroup);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public FulfillmentGroup addFulfillmentGroupToOrder(FulfillmentGroupRequest fulfillmentGroupRequest, boolean priceOrder) throws PricingException {
        FulfillmentGroup fg = this.fulfillmentGroupDao.create();
        fg.setAddress(fulfillmentGroupRequest.getAddress());
        fg.setOrder(fulfillmentGroupRequest.getOrder());
        fg.setPhone(fulfillmentGroupRequest.getPhone());
        fg.setFulfillmentOption(fulfillmentGroupRequest.getOption());
        fg.setType(fulfillmentGroupRequest.getFulfillmentType());
        for (int i = 0; i < fulfillmentGroupRequest.getFulfillmentGroupItemRequests().size(); ++i) {
            FulfillmentGroupItemRequest request = fulfillmentGroupRequest.getFulfillmentGroupItemRequests().get(i);
            request.setFulfillmentGroup(fg);
            request.setOrder(fulfillmentGroupRequest.getOrder());
            boolean shouldPriceOrder = priceOrder && i == fulfillmentGroupRequest.getFulfillmentGroupItemRequests().size() - 1;
            fg = this.addItemToFulfillmentGroup(request, shouldPriceOrder);
        }
        return fg;
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(FulfillmentGroupItemRequest fulfillmentGroupItemRequest, boolean priceOrder) throws PricingException {
        return this.addItemToFulfillmentGroup(fulfillmentGroupItemRequest, priceOrder, true);
    }

    @Override
    public FulfillmentGroup addItemToFulfillmentGroup(FulfillmentGroupItemRequest fulfillmentGroupItemRequest, boolean priceOrder, boolean save) throws PricingException {
        if (priceOrder && !save) {
            throw new IllegalArgumentException("Pricing requires a save");
        }
        Order order = fulfillmentGroupItemRequest.getOrder();
        OrderItem item = fulfillmentGroupItemRequest.getOrderItem();
        FulfillmentGroup fulfillmentGroup = fulfillmentGroupItemRequest.getFulfillmentGroup();
        if (order == null) {
            if (item.getOrder() != null) {
                order = item.getOrder();
            } else {
                throw new IllegalArgumentException("Order must not be null");
            }
        }
        for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
            Iterator<FulfillmentGroupItem> itr = fg.getFulfillmentGroupItems().iterator();
            while (itr.hasNext()) {
                FulfillmentGroupItem fgItem = itr.next();
                if (!fgItem.getOrderItem().equals(item)) continue;
                itr.remove();
                this.fulfillmentGroupItemDao.delete(fgItem);
            }
        }
        if (fulfillmentGroup == null) {
            fulfillmentGroup = this.fulfillmentGroupDao.create();
            FulfillmentGroupRequest fgRequest = new FulfillmentGroupRequest();
            fgRequest.setOrder(order);
            fulfillmentGroup = this.addFulfillmentGroupToOrder(fgRequest, false);
            fulfillmentGroup = this.save(fulfillmentGroup);
            order.getFulfillmentGroups().add(fulfillmentGroup);
        }
        FulfillmentGroupItem fgi = this.createFulfillmentGroupItemFromOrderItem(item, fulfillmentGroup, fulfillmentGroupItemRequest.getQuantity());
        if (save) {
            fgi = this.fulfillmentGroupItemDao.save(fgi);
        }
        fulfillmentGroup.addFulfillmentGroupItem(fgi);
        if (save) {
            order = this.orderService.save(order, priceOrder);
        }
        return fulfillmentGroup;
    }

    @Override
    public List<FulfillmentGroupItem> getFulfillmentGroupItemsForOrderItem(Order order, OrderItem orderItem) {
        ArrayList<FulfillmentGroupItem> fgis = new ArrayList<FulfillmentGroupItem>();
        List<FulfillmentGroup> fulfillmentGroups = order.getFulfillmentGroups();
        for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
            block1: for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                if (fulfillmentGroupItem.getOrderItem().equals(orderItem)) {
                    fgis.add(fulfillmentGroupItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (!fulfillmentGroupItem.getOrderItem().equals(discreteOrderItem)) continue;
                    fgis.add(fulfillmentGroupItem);
                    continue block1;
                }
            }
        }
        return fgis;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void removeOrderItemFromFullfillmentGroups(Order order, OrderItem orderItem) {
        List<FulfillmentGroup> fulfillmentGroups = order.getFulfillmentGroups();
        for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
            Iterator<FulfillmentGroupItem> itr = fulfillmentGroup.getFulfillmentGroupItems().iterator();
            block1: while (itr.hasNext()) {
                FulfillmentGroupItem fulfillmentGroupItem = itr.next();
                if (fulfillmentGroupItem.getOrderItem().equals(orderItem)) {
                    itr.remove();
                    this.fulfillmentGroupItemDao.delete(fulfillmentGroupItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (!fulfillmentGroupItem.getOrderItem().equals(discreteOrderItem)) continue;
                    itr.remove();
                    this.fulfillmentGroupItemDao.delete(fulfillmentGroupItem);
                    continue block1;
                }
            }
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order collapseToOneShippableFulfillmentGroup(Order order, boolean priceOrder) throws PricingException {
        if (order.getFulfillmentGroups() == null || order.getFulfillmentGroups().size() < 2) {
            return order;
        }
        ArrayList<FulfillmentGroup> shippableFulfillmentGroupList = new ArrayList<FulfillmentGroup>();
        ArrayList<FulfillmentGroup> nonShippableFulfillmentGroupList = new ArrayList<FulfillmentGroup>();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (this.isShippable(fulfillmentGroup.getType())) {
                shippableFulfillmentGroupList.add(fulfillmentGroup);
                continue;
            }
            nonShippableFulfillmentGroupList.add(fulfillmentGroup);
        }
        if (shippableFulfillmentGroupList.size() < 2) {
            return order;
        }
        ListIterator fgIter = shippableFulfillmentGroupList.listIterator();
        FulfillmentGroup collapsedFg = (FulfillmentGroup)fgIter.next();
        ArrayList<FulfillmentGroup> newFulfillmentGroupList = nonShippableFulfillmentGroupList;
        newFulfillmentGroupList.add(collapsedFg);
        order.setFulfillmentGroups(newFulfillmentGroupList);
        HashMap<Long, FulfillmentGroupItem> fgOrderItemMap = new HashMap<Long, FulfillmentGroupItem>();
        for (FulfillmentGroupItem fgi : collapsedFg.getFulfillmentGroupItems()) {
            fgOrderItemMap.put(fgi.getOrderItem().getId(), fgi);
        }
        while (fgIter.hasNext()) {
            FulfillmentGroup fg = (FulfillmentGroup)fgIter.next();
            ListIterator<FulfillmentGroupItem> fgItemIter = fg.getFulfillmentGroupItems().listIterator();
            while (fgItemIter.hasNext()) {
                FulfillmentGroupItem fgi = fgItemIter.next();
                Long orderItemId = fgi.getOrderItem().getId();
                FulfillmentGroupItem matchingFgi = (FulfillmentGroupItem)fgOrderItemMap.get(orderItemId);
                if (matchingFgi == null) {
                    matchingFgi = this.fulfillmentGroupItemDao.create();
                    matchingFgi.setFulfillmentGroup(collapsedFg);
                    matchingFgi.setOrderItem(fgi.getOrderItem());
                    matchingFgi.setQuantity(fgi.getQuantity());
                    matchingFgi = this.fulfillmentGroupItemDao.save(matchingFgi);
                    collapsedFg.getFulfillmentGroupItems().add(matchingFgi);
                    fgOrderItemMap.put(orderItemId, matchingFgi);
                } else {
                    matchingFgi.setQuantity(matchingFgi.getQuantity() + fgi.getQuantity());
                }
                this.fulfillmentGroupItemDao.delete(fgi);
                fgItemIter.remove();
            }
            this.fulfillmentGroupDao.delete(fg);
            fgIter.remove();
        }
        return this.orderService.save(order, priceOrder);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order matchFulfillmentGroupsToMultishipOptions(Order order, boolean priceOrder) throws PricingException {
        FulfillmentGroup fg;
        String key;
        List<OrderMultishipOption> multishipOptions = this.orderMultishipOptionService.findOrderMultishipOptions(order.getId());
        HashMap<Long, Integer> fgItemQuantityMap = new HashMap<Long, Integer>();
        HashMap<String, FulfillmentGroup> multishipGroups = new HashMap<String, FulfillmentGroup>();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            if (!this.isShippable(fulfillmentGroup.getType())) continue;
            key = this.getKey(fulfillmentGroup.getAddress(), fulfillmentGroup.getFulfillmentOption(), fulfillmentGroup.getType());
            multishipGroups.put(key, fulfillmentGroup);
            for (FulfillmentGroupItem fgi : fulfillmentGroup.getFulfillmentGroupItems()) {
                fgItemQuantityMap.put(fgi.getId(), fgi.getQuantity());
            }
        }
        for (OrderMultishipOption orderMultishipOption : multishipOptions) {
            key = this.getKey(orderMultishipOption.getAddress(), orderMultishipOption.getFulfillmentOption(), ((DiscreteOrderItem)orderMultishipOption.getOrderItem()).getSku().getFulfillmentType());
            fg = (FulfillmentGroup)multishipGroups.get(key);
            if (fg == null) {
                FulfillmentGroupRequest fgr = new FulfillmentGroupRequest();
                fgr.setOrder(order);
                if (orderMultishipOption.getAddress() != null) {
                    fgr.setAddress(orderMultishipOption.getAddress());
                }
                if (orderMultishipOption.getFulfillmentOption() != null) {
                    fgr.setOption(orderMultishipOption.getFulfillmentOption());
                }
                fgr.setFulfillmentType(((DiscreteOrderItem)orderMultishipOption.getOrderItem()).getSku().getFulfillmentType());
                fg = this.addFulfillmentGroupToOrder(fgr, false);
                fg = this.save(fg);
                order.getFulfillmentGroups().add(fg);
            }
            FulfillmentGroupItem fulfillmentGroupItem = null;
            for (FulfillmentGroupItem fgi : fg.getFulfillmentGroupItems()) {
                if (fgi.getOrderItem().getId() != orderMultishipOption.getOrderItem().getId()) continue;
                fulfillmentGroupItem = fgi;
            }
            if (fulfillmentGroupItem == null) {
                fulfillmentGroupItem = this.fulfillmentGroupItemDao.create();
                fulfillmentGroupItem.setFulfillmentGroup(fg);
                fulfillmentGroupItem.setOrderItem(orderMultishipOption.getOrderItem());
                fulfillmentGroupItem.setQuantity(1);
                fulfillmentGroupItem = this.fulfillmentGroupItemDao.save(fulfillmentGroupItem);
                fg.getFulfillmentGroupItems().add(fulfillmentGroupItem);
            } else if (fulfillmentGroupItem.getId() != null) {
                Integer qty = (Integer)fgItemQuantityMap.get(fulfillmentGroupItem.getId());
                if (qty == null || qty == 0) {
                    fulfillmentGroupItem.setQuantity(fulfillmentGroupItem.getQuantity() + 1);
                } else {
                    qty = qty - 1;
                    fgItemQuantityMap.put(fulfillmentGroupItem.getId(), qty);
                }
            } else {
                fulfillmentGroupItem.setQuantity(fulfillmentGroupItem.getQuantity() + 1);
            }
            multishipGroups.put(key, fg);
        }
        for (Map.Entry entry : fgItemQuantityMap.entrySet()) {
            if ((Integer)entry.getValue() <= 0) continue;
            FulfillmentGroupItem fgi = this.fulfillmentGroupItemDao.readFulfillmentGroupItemById((Long)entry.getKey());
            if (fgi.getQuantity() == ((Integer)entry.getValue()).intValue()) {
                fg = fgi.getFulfillmentGroup();
                fg.getFulfillmentGroupItems().remove(fgi);
                this.fulfillmentGroupItemDao.delete(fgi);
                if (fg.getFulfillmentGroupItems().size() != 0) continue;
                order.getFulfillmentGroups().remove(fg);
                this.fulfillmentGroupDao.delete(fg);
                continue;
            }
            fgi.setQuantity(fgi.getQuantity() - (Integer)entry.getValue());
            this.fulfillmentGroupItemDao.save(fgi);
        }
        return this.orderService.save(order, priceOrder);
    }

    protected String getKey(Address address, FulfillmentOption option, FulfillmentType fulfillmentType) {
        Long addressKey = address == null ? -1L : address.getId();
        Long fulfillmentOptionKey = option == null ? -1L : option.getId();
        String fulfillmentTypeKey = fulfillmentType == null ? "-1" : fulfillmentType.getType();
        return addressKey + ":" + fulfillmentOptionKey + ":" + fulfillmentTypeKey;
    }

    protected FulfillmentGroupItem createFulfillmentGroupItemFromOrderItem(OrderItem orderItem, FulfillmentGroup fulfillmentGroup, int quantity) {
        FulfillmentGroupItem fgi = this.fulfillmentGroupItemDao.create();
        fgi.setFulfillmentGroup(fulfillmentGroup);
        fgi.setOrderItem(orderItem);
        fgi.setQuantity(quantity);
        return fgi;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Order removeAllFulfillmentGroupsFromOrder(Order order, boolean priceOrder) throws PricingException {
        if (order.getFulfillmentGroups() != null) {
            Iterator<FulfillmentGroup> iterator = order.getFulfillmentGroups().iterator();
            while (iterator.hasNext()) {
                FulfillmentGroup fulfillmentGroup = iterator.next();
                iterator.remove();
                this.fulfillmentGroupDao.delete(fulfillmentGroup);
            }
            order = this.orderService.save(order, priceOrder);
        }
        return order;
    }

    @Override
    public FulfillmentGroupFee createFulfillmentGroupFee() {
        return this.fulfillmentGroupDao.createFulfillmentGroupFee();
    }

    @Override
    public List<FulfillmentGroup> findUnfulfilledFulfillmentGroups(int start, int maxResults) {
        return this.fulfillmentGroupDao.readUnfulfilledFulfillmentGroups(start, maxResults);
    }

    @Override
    public List<FulfillmentGroup> findPartiallyFulfilledFulfillmentGroups(int start, int maxResults) {
        return this.fulfillmentGroupDao.readPartiallyFulfilledFulfillmentGroups(start, maxResults);
    }

    @Override
    public List<FulfillmentGroup> findUnprocessedFulfillmentGroups(int start, int maxResults) {
        return this.fulfillmentGroupDao.readUnprocessedFulfillmentGroups(start, maxResults);
    }

    @Override
    public List<FulfillmentGroup> findFulfillmentGroupsByStatus(FulfillmentGroupStatusType status, int start, int maxResults, boolean ascending) {
        return this.fulfillmentGroupDao.readFulfillmentGroupsByStatus(status, start, maxResults, ascending);
    }

    @Override
    public List<FulfillmentGroup> findFulfillmentGroupsByStatus(FulfillmentGroupStatusType status, int start, int maxResults) {
        return this.fulfillmentGroupDao.readFulfillmentGroupsByStatus(status, start, maxResults);
    }

    @Override
    public boolean isShippable(FulfillmentType fulfillmentType) {
        block3: {
            block2: {
                if (FulfillmentType.GIFT_CARD.equals(fulfillmentType)) break block2;
                if (FulfillmentType.DIGITAL.equals(fulfillmentType)) break block2;
                if (!FulfillmentType.PHYSICAL_PICKUP.equals(fulfillmentType)) break block3;
            }
            return false;
        }
        return true;
    }

    @Override
    public FulfillmentGroup getFirstShippableFulfillmentGroup(Order order) {
        List<FulfillmentGroup> fulfillmentGroups = order.getFulfillmentGroups();
        if (fulfillmentGroups != null) {
            for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
                if (!this.isShippable(fulfillmentGroup.getType())) continue;
                return fulfillmentGroup;
            }
        }
        return null;
    }
}

