/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableCandidateFulfillmentGroupOfferImpl
implements PromotableCandidateFulfillmentGroupOffer {
    private static final long serialVersionUID = 1L;
    protected HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateQualifiersMap = new HashMap();
    protected Offer offer;
    protected PromotableFulfillmentGroup promotableFulfillmentGroup;

    public PromotableCandidateFulfillmentGroupOfferImpl(PromotableFulfillmentGroup promotableFulfillmentGroup, Offer offer) {
        assert (offer != null);
        assert (promotableFulfillmentGroup != null);
        this.offer = offer;
        this.promotableFulfillmentGroup = promotableFulfillmentGroup;
    }

    @Override
    public HashMap<OfferItemCriteria, List<PromotableOrderItem>> getCandidateQualifiersMap() {
        return this.candidateQualifiersMap;
    }

    @Override
    public void setCandidateQualifiersMap(HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateItemsMap) {
        this.candidateQualifiersMap = candidateItemsMap;
    }

    protected Money getBasePrice() {
        Money priceToUse = null;
        if (this.promotableFulfillmentGroup.getFulfillmentGroup().getRetailFulfillmentPrice() != null) {
            priceToUse = this.promotableFulfillmentGroup.getFulfillmentGroup().getRetailFulfillmentPrice();
            if (this.offer.getApplyDiscountToSalePrice() && this.promotableFulfillmentGroup.getFulfillmentGroup().getSaleFulfillmentPrice() != null) {
                priceToUse = this.promotableFulfillmentGroup.getFulfillmentGroup().getSaleFulfillmentPrice();
            }
        }
        return priceToUse;
    }

    @Override
    public Money computeDiscountedAmount() {
        Money discountedAmount = new Money(0);
        Money priceToUse = this.getBasePrice();
        if (priceToUse != null) {
            if (this.offer.getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                discountedAmount = BroadleafCurrencyUtils.getMoney((BigDecimal)this.offer.getValue(), (BroadleafCurrency)this.promotableFulfillmentGroup.getFulfillmentGroup().getOrder().getCurrency());
            } else if (this.offer.getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                discountedAmount = priceToUse.subtract(BroadleafCurrencyUtils.getMoney((BigDecimal)this.offer.getValue(), (BroadleafCurrency)this.promotableFulfillmentGroup.getFulfillmentGroup().getOrder().getCurrency()));
            } else if (this.offer.getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                discountedAmount = priceToUse.multiply(this.offer.getValue().divide(new BigDecimal("100")));
            }
            if (discountedAmount.greaterThan(priceToUse)) {
                discountedAmount = priceToUse;
            }
        }
        return discountedAmount;
    }

    @Override
    public Money getDiscountedPrice() {
        return this.getBasePrice().subtract(this.computeDiscountedAmount());
    }

    @Override
    public Money getDiscountedAmount() {
        return this.computeDiscountedAmount();
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public PromotableFulfillmentGroup getFulfillmentGroup() {
        return this.promotableFulfillmentGroup;
    }

    public int getPriority() {
        return this.offer.getPriority();
    }
}

