/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetailImpl;
import org.broadleafcommerce.core.order.service.type.OrderItemType;

public class OrderItemTest
extends TestCase {
    private PromotableOrderItemPriceDetail priceDetail1;
    private PromotableCandidateItemOffer candidateOffer;
    private Offer offer;

    protected void setUp() throws Exception {
        PromotableOrderImpl promotableOrder = new PromotableOrderImpl((Order)new OrderImpl(), (PromotableItemFactory)new PromotableItemFactoryImpl(), false);
        DiscreteOrderItemImpl discreteOrderItem1 = new DiscreteOrderItemImpl();
        discreteOrderItem1.setName("test1");
        discreteOrderItem1.setOrderItemType(OrderItemType.DISCRETE);
        discreteOrderItem1.setQuantity(2);
        discreteOrderItem1.setRetailPrice(new Money(19.99));
        OrderItemPriceDetailImpl pdetail = new OrderItemPriceDetailImpl();
        pdetail.setOrderItem((OrderItem)discreteOrderItem1);
        pdetail.setQuantity(2);
        PromotableOrderItemImpl orderItem1 = new PromotableOrderItemImpl((OrderItem)discreteOrderItem1, null, (PromotableItemFactory)new PromotableItemFactoryImpl(), false);
        this.priceDetail1 = new PromotableOrderItemPriceDetailImpl((PromotableOrderItem)orderItem1, 2);
        OfferDataItemProvider dataProvider = new OfferDataItemProvider();
        this.offer = dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        this.candidateOffer = new PromotableCandidateItemOfferImpl((PromotableOrder)promotableOrder, this.offer);
    }

    public void testGetQuantityAvailableToBeUsedAsQualifier() throws Exception {
        int quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 2 ? 1 : 0) != 0);
        PromotionDiscount discount = new PromotionDiscount();
        discount.setPromotion(this.offer);
        discount.setQuantity(1);
        this.priceDetail1.getPromotionDiscounts().add(discount);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        OfferImpl testOffer = new OfferImpl();
        testOffer.setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.NONE);
        testOffer.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.NONE);
        discount.setPromotion((Offer)testOffer);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        testOffer.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.QUALIFIER);
        this.candidateOffer.getOffer().setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.TARGET);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 2 ? 1 : 0) != 0);
        this.priceDetail1.getPromotionDiscounts().clear();
        PromotionQualifier qualifier = new PromotionQualifier();
        qualifier.setPromotion(this.offer);
        qualifier.setQuantity(1);
        this.priceDetail1.getPromotionQualifiers().add(qualifier);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        qualifier.setPromotion((Offer)testOffer);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        testOffer.setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.QUALIFIER);
        this.candidateOffer.getOffer().setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.QUALIFIER);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsQualifier(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 2 ? 1 : 0) != 0);
    }

    public void testGetQuantityAvailableToBeUsedAsTarget() throws Exception {
        int quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 2 ? 1 : 0) != 0);
        PromotionDiscount discount = new PromotionDiscount();
        discount.setPromotion(this.offer);
        discount.setQuantity(1);
        this.priceDetail1.getPromotionDiscounts().add(discount);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        OfferImpl tempOffer = new OfferImpl();
        tempOffer.setCombinableWithOtherOffers(true);
        tempOffer.setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.NONE);
        tempOffer.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.NONE);
        discount.setPromotion((Offer)tempOffer);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        tempOffer.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.TARGET);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        this.candidateOffer.getOffer().setOfferItemTargetRuleType(OfferItemRestrictionRuleType.TARGET);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 2 ? 1 : 0) != 0);
        this.priceDetail1.getPromotionDiscounts().clear();
        this.candidateOffer.getOffer().setOfferItemTargetRuleType(OfferItemRestrictionRuleType.NONE);
        PromotionQualifier qualifier = new PromotionQualifier();
        qualifier.setPromotion(this.offer);
        qualifier.setQuantity(1);
        this.priceDetail1.getPromotionQualifiers().add(qualifier);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        qualifier.setPromotion((Offer)tempOffer);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 1 ? 1 : 0) != 0);
        tempOffer.setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.TARGET);
        this.candidateOffer.getOffer().setOfferItemTargetRuleType(OfferItemRestrictionRuleType.QUALIFIER);
        quantity = this.priceDetail1.getQuantityAvailableToBeUsedAsTarget(this.candidateOffer);
        OrderItemTest.assertTrue((quantity == 2 ? 1 : 0) != 0);
    }
}

