/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfigurationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfigurationServiceProvider;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.domain.secure.CreditCardPayment;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.payment.service.OrderToPaymentRequestDTOService;
import org.broadleafcommerce.core.payment.service.SecureOrderPaymentService;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValidateAndConfirmPaymentActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    protected static final Log LOG = LogFactory.getLog(ValidateAndConfirmPaymentActivity.class);
    public static final String CONFIRMED_TRANSACTIONS = "confirmedTransactions";
    @Autowired(required=false)
    @Qualifier(value="blPaymentGatewayConfigurationServiceProvider")
    protected PaymentGatewayConfigurationServiceProvider paymentConfigurationServiceProvider;
    @Resource(name="blOrderToPaymentRequestDTOService")
    protected OrderToPaymentRequestDTOService orderToPaymentRequestService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;
    @Resource(name="blSecureOrderPaymentService")
    protected SecureOrderPaymentService secureOrderPaymentService;

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        Order order = context.getSeedData().getOrder();
        HashMap<String, Object> rollbackState = new HashMap<String, Object>();
        HashMap<OrderPayment, PaymentTransaction> additionalTransactions = new HashMap<OrderPayment, PaymentTransaction>();
        ArrayList<PaymentResponseDTO> failedTransactions = new ArrayList<PaymentResponseDTO>();
        ArrayList<PaymentTransaction> confirmedTransactions = new ArrayList<PaymentTransaction>();
        HashMap<OrderPayment, PaymentTransactionType> confirmedRollback = new HashMap<OrderPayment, PaymentTransactionType>();
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            for (PaymentTransaction tx : payment.getTransactions()) {
                if (PaymentTransactionType.UNCONFIRMED.equals((Object)tx.getType())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Transaction " + tx.getId() + " is not confirmed. Proceeding to confirm transaction."));
                    }
                    if (this.paymentConfigurationServiceProvider == null) {
                        String msg = "There are unconfirmed payment transactions on this payment but no payment gateway configuration or transaction confirmation service configured";
                        LOG.error((Object)msg);
                        throw new CheckoutException(msg, context.getSeedData());
                    }
                    PaymentGatewayConfigurationService cfg = this.paymentConfigurationServiceProvider.getGatewayConfigurationService(tx.getOrderPayment().getGatewayType());
                    PaymentResponseDTO responseDTO = null;
                    if (PaymentType.CREDIT_CARD.equals((Object)payment.getType())) {
                        PaymentRequestDTO s2sRequest = this.orderToPaymentRequestService.translatePaymentTransaction(payment.getAmount(), tx);
                        this.populateCreditCardOnRequest(s2sRequest, payment);
                        this.populateBillingAddressOnRequest(s2sRequest, payment);
                        this.populateCustomerOnRequest(s2sRequest, payment);
                        responseDTO = cfg.getConfiguration().isPerformAuthorizeAndCapture() ? cfg.getTransactionService().authorizeAndCapture(s2sRequest) : cfg.getTransactionService().authorize(s2sRequest);
                    } else {
                        responseDTO = cfg.getTransactionConfirmationService().confirmTransaction(this.orderToPaymentRequestService.translatePaymentTransaction(payment.getAmount(), tx));
                    }
                    if (responseDTO == null) {
                        String msg = "Unable to Confirm/Authorize the UNCONFIRMED Transaction with id: " + tx.getId() + ". " + "The ResponseDTO returned from the Gateway was null. Please check your implementation";
                        LOG.error((Object)msg);
                        throw new CheckoutException(msg, context.getSeedData());
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Transaction Confirmation Raw Response: " + responseDTO.getRawResponse()));
                    }
                    if (responseDTO.getAmount() == null || responseDTO.getPaymentTransactionType() == null) {
                        LOG.error((Object)"The ResponseDTO returned from the Gateway does not contain either an Amount or Payment Transaction Type. Please check your implementation");
                    }
                    PaymentTransaction transaction = this.orderPaymentService.createTransaction();
                    transaction.setAmount(responseDTO.getAmount());
                    transaction.setRawResponse(responseDTO.getRawResponse());
                    transaction.setSuccess(responseDTO.isSuccessful());
                    transaction.setType(responseDTO.getPaymentTransactionType());
                    transaction.setParentTransaction(tx);
                    transaction.setOrderPayment(payment);
                    transaction.setAdditionalFields(responseDTO.getResponseMap());
                    additionalTransactions.put(payment, transaction);
                    if (responseDTO.isSuccessful()) {
                        confirmedRollback.put(payment, transaction.getType());
                        continue;
                    }
                    failedTransactions.add(responseDTO);
                    continue;
                }
                if (!PaymentTransactionType.AUTHORIZE.equals((Object)tx.getType()) && !PaymentTransactionType.AUTHORIZE_AND_CAPTURE.equals((Object)tx.getType())) continue;
                confirmedRollback.put(payment, tx.getType());
            }
        }
        for (OrderPayment payment : order.getPayments()) {
            if (!additionalTransactions.containsKey(payment)) continue;
            PaymentTransactionType confirmedType = null;
            if (confirmedRollback.containsKey(payment)) {
                confirmedType = (PaymentTransactionType)confirmedRollback.get(payment);
            }
            payment.addTransaction((PaymentTransaction)additionalTransactions.get(payment));
            payment = this.orderPaymentService.save(payment);
            if (confirmedType == null) continue;
            List<PaymentTransaction> types = payment.getTransactionsForType(confirmedType);
            if (types.size() == 1) {
                confirmedTransactions.add(types.get(0));
                continue;
            }
            throw new IllegalArgumentException("There should only be one AUTHORIZE or AUTHORIZE_AND_CAPTURE transaction.There are more than one confirmed payment transactions for Order Payment:" + payment.getId());
        }
        rollbackState.put(CONFIRMED_TRANSACTIONS, confirmedTransactions);
        ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackHandler(), rollbackState);
        if (!failedTransactions.isEmpty()) {
            this.handleUnsuccessfulTransactions(failedTransactions, context);
        }
        Money paymentSum = new Money(BigDecimal.ZERO);
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            paymentSum = paymentSum.add(payment.getSuccessfulTransactionAmountForType(PaymentTransactionType.AUTHORIZE)).add(payment.getSuccessfulTransactionAmountForType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE));
        }
        if (paymentSum.lessThan(order.getTotal())) {
            throw new IllegalArgumentException("There are not enough payments to pay for the total order. The sum of the payments is " + paymentSum.getAmount().toPlainString() + " and the order total is " + order.getTotal().getAmount().toPlainString());
        }
        return context;
    }

    protected void handleUnsuccessfulTransactions(List<PaymentResponseDTO> responseDTOs, ProcessContext<CheckoutSeed> context) throws Exception {
        String msg = "Attempting to confirm/authorize an UNCONFIRMED transaction on the order was unsuccessful.";
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)msg);
        }
        if (LOG.isTraceEnabled()) {
            for (PaymentResponseDTO responseDTO : responseDTOs) {
                LOG.trace((Object)responseDTO.getRawResponse());
            }
        }
        throw new CheckoutException(msg, context.getSeedData());
    }

    protected void populateCreditCardOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) throws WorkflowException {
        CreditCardPayment creditCardPayment;
        if (payment.getReferenceNumber() != null && (creditCardPayment = (CreditCardPayment)this.secureOrderPaymentService.findSecurePaymentInfo(payment.getReferenceNumber(), PaymentType.CREDIT_CARD)) != null) {
            requestDTO.creditCard().creditCardHolderName(creditCardPayment.getNameOnCard()).creditCardNum(creditCardPayment.getPan()).creditCardExpDate(this.constructExpirationDate(creditCardPayment.getExpirationMonth(), creditCardPayment.getExpirationYear())).creditCardExpMonth(creditCardPayment.getExpirationMonth() + "").creditCardExpYear(creditCardPayment.getExpirationYear() + "").done();
        }
    }

    protected void populateBillingAddressOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) {
        if (payment != null && payment.getBillingAddress() != null) {
            Address address = payment.getBillingAddress();
            String addressLine2 = address.getAddressLine2();
            if (StringUtils.isNotBlank((String)address.getAddressLine3())) {
                addressLine2 = addressLine2 + " " + address.getAddressLine3();
            }
            String state = address.getState() != null ? address.getState().getAbbreviation() : null;
            String country = address.getCountry() != null ? address.getCountry().getAbbreviation() : null;
            String phone = address.getPhonePrimary() != null ? address.getPhonePrimary().getPhoneNumber() : null;
            requestDTO.billTo().addressFirstName(address.getFirstName()).addressLastName(address.getLastName()).addressLine1(address.getAddressLine1()).addressLine2(addressLine2).addressCityLocality(address.getCity()).addressStateRegion(state).addressPostalCode(address.getPostalCode()).addressCountryCode(country).addressEmail(address.getEmailAddress()).addressPhone(phone).addressCompanyName(address.getCompanyName()).done();
        }
    }

    protected void populateCustomerOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) {
        if (payment != null && payment.getOrder() != null && payment.getOrder().getCustomer() != null) {
            Customer customer = payment.getOrder().getCustomer();
            requestDTO.customer().firstName(customer.getFirstName()).lastName(customer.getLastName()).email(customer.getEmailAddress()).customerId(customer.getId() + "").done();
        }
    }

    protected String constructExpirationDate(Integer expMonth, Integer expYear) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getGatewayExpirationDateFormat());
        DateTime exp = new DateTime().withYear(expYear.intValue()).withMonthOfYear(expMonth.intValue());
        return sdf.format(exp.toDate());
    }

    protected String getGatewayExpirationDateFormat() {
        String format = BLCSystemProperty.resolveSystemProperty((String)"gateway.config.global.expDateFormat");
        if (StringUtils.isBlank((String)format)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"The System Property 'gateway.config.global.expDateFormat' is not set. Defaulting to the format 'MM/YY' for the configured gateway.");
            }
            format = "MM/YY";
        }
        return format;
    }
}

