/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.update.options;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class ValidateUpdateProductOptionsRequestActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        DiscreteOrderItem doi;
        CartOperationRequest request = context.getSeedData();
        OrderItemRequestDTO orderItemRequestDTO = request.getItemRequest();
        if (orderItemRequestDTO.getOrderItemId() == null) {
            throw new IllegalArgumentException("OrderItemId must be specified to locate the order item");
        }
        if (request.getOrder() == null) {
            throw new IllegalArgumentException("Order is required when updating items in the order");
        }
        OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemRequestDTO.getOrderItemId());
        if (orderItem == null || !(orderItem instanceof DiscreteOrderItem) || (doi = (DiscreteOrderItem)orderItem).getBundleOrderItem() != null) {
            // empty if block
        }
        return context;
    }
}

