/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.dao.SearchFacetDao;
import org.broadleafcommerce.core.search.domain.CategorySearchFacet;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.search.service.SearchService;
import org.springframework.stereotype.Service;

@Service(value="blSearchService")
public class DatabaseSearchServiceImpl
implements SearchService {
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blSearchFacetDao")
    protected SearchFacetDao searchFacetDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    protected static String CACHE_NAME = "blStandardElements";
    protected static String CACHE_KEY_PREFIX = "facet:";
    protected Cache cache = CacheManager.getInstance().getCache(CACHE_NAME);

    @Override
    public ProductSearchResult findExplicitProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        throw new UnsupportedOperationException("See findProductsByCategory or use the SolrSearchService implementation");
    }

    @Override
    public ProductSearchResult findProductsByCategoryAndQuery(Category category, String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        throw new UnsupportedOperationException("This operation is only supported by the SolrSearchService by default");
    }

    @Override
    public ProductSearchResult findProductsByCategory(Category category, ProductSearchCriteria searchCriteria) {
        ProductSearchResult result = new ProductSearchResult();
        this.setQualifiedKeys(searchCriteria);
        List<Product> products = this.catalogService.findFilteredActiveProductsByCategory(category, searchCriteria);
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        this.setActiveFacets(facets, searchCriteria);
        result.setProducts(products);
        result.setFacets(facets);
        result.setTotalResults(products.size());
        result.setPage(1);
        result.setPageSize(products.size());
        return result;
    }

    @Override
    public ProductSearchResult findProductsByQuery(String query, ProductSearchCriteria searchCriteria) {
        ProductSearchResult result = new ProductSearchResult();
        this.setQualifiedKeys(searchCriteria);
        List<Product> products = this.catalogService.findFilteredActiveProductsByQuery(query, searchCriteria);
        List<SearchFacetDTO> facets = this.getSearchFacets();
        this.setActiveFacets(facets, searchCriteria);
        result.setProducts(products);
        result.setFacets(facets);
        result.setTotalResults(products.size());
        result.setPage(1);
        result.setPageSize(products.size());
        return result;
    }

    @Override
    public List<SearchFacetDTO> getSearchFacets() {
        List<SearchFacetDTO> facets = null;
        String cacheKey = CACHE_KEY_PREFIX + "blc-search";
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element != null) {
            facets = (List<SearchFacetDTO>)((Object)element.getValue());
        }
        if (facets == null) {
            facets = this.buildSearchFacetDtos(this.searchFacetDao.readAllSearchFacets());
            element = new Element((Object)cacheKey, facets);
            this.cache.put(element);
        }
        return facets;
    }

    @Override
    public List<SearchFacetDTO> getCategoryFacets(Category category) {
        List<SearchFacetDTO> facets = null;
        String cacheKey = CACHE_KEY_PREFIX + "category:" + category.getId();
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element != null) {
            facets = (List<SearchFacetDTO>)((Object)element.getValue());
        }
        if (facets == null) {
            List<CategorySearchFacet> categorySearchFacets = category.getCumulativeSearchFacets();
            ArrayList<SearchFacet> searchFacets = new ArrayList<SearchFacet>();
            for (CategorySearchFacet categorySearchFacet : categorySearchFacets) {
                searchFacets.add(categorySearchFacet.getSearchFacet());
            }
            facets = this.buildSearchFacetDtos(searchFacets);
            element = new Element((Object)cacheKey, facets);
            this.cache.put(element);
        }
        return facets;
    }

    protected void setQualifiedKeys(ProductSearchCriteria criteria) {
        HashMap<String, String[]> convertedFilterCriteria = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : criteria.getFilterCriteria().entrySet()) {
            Field field = this.fieldDao.readFieldByAbbreviation(entry.getKey());
            if (field == null) continue;
            String qualifiedFieldName = this.getDatabaseQualifiedFieldName(field.getQualifiedFieldName());
            convertedFilterCriteria.put(qualifiedFieldName, entry.getValue());
        }
        criteria.setFilterCriteria(convertedFilterCriteria);
        if (StringUtils.isNotBlank((String)criteria.getSortQuery())) {
            StringBuilder convertedSortQuery = new StringBuilder();
            for (String sortQuery : criteria.getSortQuery().split(",")) {
                String[] sort = sortQuery.split(" ");
                if (sort.length != 2) continue;
                String key = sort[0];
                Field field = this.fieldDao.readFieldByAbbreviation(key);
                String qualifiedFieldName = this.getDatabaseQualifiedFieldName(field.getQualifiedFieldName());
                if (convertedSortQuery.length() > 0) {
                    convertedSortQuery.append(",");
                }
                convertedSortQuery.append(qualifiedFieldName).append(" ").append(sort[1]);
            }
            criteria.setSortQuery(convertedSortQuery.toString());
        }
    }

    protected String getDatabaseQualifiedFieldName(String qualifiedFieldName) {
        if (qualifiedFieldName.contains("productAttributes")) {
            return qualifiedFieldName.replace("product.", "");
        }
        if (qualifiedFieldName.contains("defaultSku")) {
            return qualifiedFieldName.replace("product.", "");
        }
        return qualifiedFieldName;
    }

    protected void setActiveFacets(List<SearchFacetDTO> facets, ProductSearchCriteria searchCriteria) {
        for (SearchFacetDTO facet : facets) {
            String qualifiedFieldName = this.getDatabaseQualifiedFieldName(facet.getFacet().getField().getQualifiedFieldName());
            for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
                if (!qualifiedFieldName.equals(entry.getKey())) continue;
                facet.setActive(true);
            }
        }
    }

    protected List<SearchFacetDTO> buildSearchFacetDtos(List<SearchFacet> categoryFacets) {
        ArrayList<SearchFacetDTO> facets = new ArrayList<SearchFacetDTO>();
        for (SearchFacet facet : categoryFacets) {
            SearchFacetDTO dto = new SearchFacetDTO();
            dto.setFacet(facet);
            dto.setShowQuantity(false);
            dto.setFacetValues(this.getFacetValues(facet));
            dto.setActive(false);
            facets.add(dto);
        }
        return facets;
    }

    protected List<SearchFacetResultDTO> getFacetValues(SearchFacet facet) {
        if (facet.getSearchFacetRanges().size() > 0) {
            return this.getRangeFacetValues(facet);
        }
        return this.getMatchFacetValues(facet);
    }

    protected List<SearchFacetResultDTO> getRangeFacetValues(SearchFacet facet) {
        ArrayList<SearchFacetResultDTO> results = new ArrayList<SearchFacetResultDTO>();
        List<SearchFacetRange> ranges = facet.getSearchFacetRanges();
        Collections.sort(ranges, new Comparator<SearchFacetRange>(){

            @Override
            public int compare(SearchFacetRange o1, SearchFacetRange o2) {
                return o1.getMinValue().compareTo(o2.getMinValue());
            }
        });
        for (SearchFacetRange range : ranges) {
            SearchFacetResultDTO dto = new SearchFacetResultDTO();
            dto.setMinValue(range.getMinValue());
            dto.setMaxValue(range.getMaxValue());
            dto.setFacet(facet);
            results.add(dto);
        }
        return results;
    }

    protected List<SearchFacetResultDTO> getMatchFacetValues(SearchFacet facet) {
        ArrayList<SearchFacetResultDTO> results = new ArrayList<SearchFacetResultDTO>();
        String qualifiedFieldName = facet.getField().getQualifiedFieldName();
        qualifiedFieldName = this.getDatabaseQualifiedFieldName(qualifiedFieldName);
        List<String> values = this.searchFacetDao.readDistinctValuesForField(qualifiedFieldName, String.class);
        Collections.sort(values);
        for (String value : values) {
            SearchFacetResultDTO dto = new SearchFacetResultDTO();
            dto.setValue(value);
            dto.setFacet(facet);
            results.add(dto);
        }
        return results;
    }

    @Override
    public void rebuildIndex() {
        throw new UnsupportedOperationException("Indexes are not supported by this implementation");
    }
}

