/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.StreamCapableTransactionalOperation;
import org.broadleafcommerce.common.util.StreamCapableTransactionalOperationAdapter;
import org.broadleafcommerce.common.util.StreamingTransactionCapableUtil;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.util.dao.ResourcePurgeDao;
import org.broadleafcommerce.core.util.service.ResourcePurgeService;
import org.broadleafcommerce.core.util.service.type.PurgeCartVariableNames;
import org.broadleafcommerce.core.util.service.type.PurgeCustomerVariableNames;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.stereotype.Service;

@Service(value="blResourcePurgeService")
public class ResourcePurgeServiceImpl
implements ResourcePurgeService {
    private static final Log LOG = LogFactory.getLog(ResourcePurgeServiceImpl.class);
    @Resource(name="blStreamingTransactionCapableUtil")
    protected StreamingTransactionCapableUtil transUtil;
    @Resource(name="blResourcePurgeDao")
    protected ResourcePurgeDao resourcePurgeDao;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    protected Integer pageSize = 10;

    @PostConstruct
    public void init() {
        if (this.pageSize != null) {
            this.transUtil.setPageSize(this.pageSize.intValue());
        }
    }

    @Override
    public void purgeCarts(final Map<String, String> config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Purging carts");
        }
        if (MapUtils.isEmpty(config)) {
            throw new IllegalArgumentException("Cannot purge carts since there was no configuration provided. In the absence of config params, all carts would be candidates for deletion.");
        }
        try {
            this.transUtil.runStreamingTransactionalOperation((StreamCapableTransactionalOperation)new StreamCapableTransactionalOperationAdapter(){

                public void pagedExecute(Object[] param) throws Throwable {
                    List orders = (List)param[0];
                    for (Order cart : orders) {
                        ResourcePurgeServiceImpl.this.deleteCart(cart);
                    }
                }

                public Object[] retrievePage(int startPos, int pageSize) {
                    List<Order> results = ResourcePurgeServiceImpl.this.getCartsToPurge(config, startPos, pageSize);
                    return new Object[]{results};
                }

                public Long retrieveTotalCount() {
                    return ResourcePurgeServiceImpl.this.getCartsToPurgeLength(config);
                }

                public boolean shouldRetryOnTransactionLockAcquisitionFailure() {
                    return true;
                }
            }, RuntimeException.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to purge carts", (Throwable)e);
        }
    }

    @Override
    public void purgeCustomers(final Map<String, String> config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Purging customers");
        }
        if (MapUtils.isEmpty(config)) {
            throw new IllegalArgumentException("Cannot purge customers since there was no configuration provided. In the absence of config params, all customers would be candidates for deletion.");
        }
        try {
            this.transUtil.runStreamingTransactionalOperation((StreamCapableTransactionalOperation)new StreamCapableTransactionalOperationAdapter(){

                public void pagedExecute(Object[] param) throws Throwable {
                    List customers = (List)param[0];
                    for (Customer customer : customers) {
                        ResourcePurgeServiceImpl.this.deleteCustomer(customer);
                    }
                }

                public Object[] retrievePage(int startPos, int pageSize) {
                    List<Customer> results = ResourcePurgeServiceImpl.this.getCustomersToPurge(config, startPos, pageSize);
                    return new Object[]{results};
                }

                public Long retrieveTotalCount() {
                    return ResourcePurgeServiceImpl.this.getCustomersToPurgeLength(config);
                }

                public boolean shouldRetryOnTransactionLockAcquisitionFailure() {
                    return true;
                }
            }, RuntimeException.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to purge customers", (Throwable)e);
        }
    }

    @Override
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    protected List<Order> getCartsToPurge(Map<String, String> config, int startPos, int length) {
        CartPurgeParams purgeParams = new CartPurgeParams(config).invoke();
        String[] nameArray = purgeParams.getNameArray();
        OrderStatus[] statusArray = purgeParams.getStatusArray();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        return this.resourcePurgeDao.findCarts(nameArray, statusArray, dateCreatedMinThreshold, isPreview, startPos, length);
    }

    protected Long getCartsToPurgeLength(Map<String, String> config) {
        CartPurgeParams purgeParams = new CartPurgeParams(config).invoke();
        String[] nameArray = purgeParams.getNameArray();
        OrderStatus[] statusArray = purgeParams.getStatusArray();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        return this.resourcePurgeDao.findCartsCount(nameArray, statusArray, dateCreatedMinThreshold, isPreview);
    }

    protected void deleteCart(Order cart) {
        try {
            this.orderService.deleteOrder(cart);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to purge a cart", (Throwable)e);
        }
    }

    protected List<Customer> getCustomersToPurge(Map<String, String> config, int startPos, int length) {
        CustomerPurgeParams purgeParams = new CustomerPurgeParams(config).invoke();
        Boolean isRegistered = purgeParams.getIsRegistered();
        Boolean isDeactivated = purgeParams.getIsDeactivated();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        return this.resourcePurgeDao.findCustomers(dateCreatedMinThreshold, isRegistered, isDeactivated, isPreview, startPos, length);
    }

    protected Long getCustomersToPurgeLength(Map<String, String> config) {
        CustomerPurgeParams purgeParams = new CustomerPurgeParams(config).invoke();
        Boolean isRegistered = purgeParams.getIsRegistered();
        Boolean isDeactivated = purgeParams.getIsDeactivated();
        Date dateCreatedMinThreshold = purgeParams.getDateCreatedMinThreshold();
        Boolean isPreview = purgeParams.getIsPreview();
        return this.resourcePurgeDao.findCustomersCount(dateCreatedMinThreshold, isRegistered, isDeactivated, isPreview);
    }

    protected void deleteCustomer(Customer customer) {
        try {
            this.customerService.deleteCustomer(customer);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to purge a customer", (Throwable)e);
        }
    }

    private class CustomerPurgeParams {
        private Map<String, String> config;
        private Date dateCreatedMinThreshold;
        private Boolean isPreview;
        private Boolean isRegistered;
        private Boolean isDeactivated;

        public CustomerPurgeParams(Map<String, String> config) {
            this.config = config;
        }

        public Date getDateCreatedMinThreshold() {
            return this.dateCreatedMinThreshold;
        }

        public Boolean getIsPreview() {
            return this.isPreview;
        }

        public Boolean getIsRegistered() {
            return this.isRegistered;
        }

        public Boolean getIsDeactivated() {
            return this.isDeactivated;
        }

        public CustomerPurgeParams invoke() {
            this.isRegistered = null;
            this.isDeactivated = null;
            this.dateCreatedMinThreshold = null;
            this.isPreview = null;
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                if (PurgeCustomerVariableNames.SECONDS_OLD.toString().equals(entry.getKey())) {
                    Long secondsOld = Long.parseLong(entry.getValue());
                    this.dateCreatedMinThreshold = new Date(SystemTime.asMillis() - secondsOld * 1000L);
                }
                if (PurgeCustomerVariableNames.IS_REGISTERED.toString().equals(entry.getKey())) {
                    this.isRegistered = Boolean.parseBoolean(entry.getValue());
                }
                if (PurgeCustomerVariableNames.IS_DEACTIVATED.toString().equals(entry.getKey())) {
                    this.isDeactivated = Boolean.parseBoolean(entry.getValue());
                }
                if (!PurgeCustomerVariableNames.IS_PREVIEW.toString().equals(entry.getKey())) continue;
                this.isPreview = Boolean.parseBoolean(entry.getValue());
            }
            return this;
        }
    }

    private class CartPurgeParams {
        private Map<String, String> config;
        private String[] nameArray;
        private OrderStatus[] statusArray;
        private Date dateCreatedMinThreshold;
        private Boolean isPreview;

        public CartPurgeParams(Map<String, String> config) {
            this.config = config;
        }

        public String[] getNameArray() {
            return this.nameArray;
        }

        public OrderStatus[] getStatusArray() {
            return this.statusArray;
        }

        public Date getDateCreatedMinThreshold() {
            return this.dateCreatedMinThreshold;
        }

        public Boolean getIsPreview() {
            return this.isPreview;
        }

        public CartPurgeParams invoke() {
            this.nameArray = null;
            this.statusArray = null;
            this.dateCreatedMinThreshold = null;
            this.isPreview = null;
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                if (PurgeCartVariableNames.STATUS.toString().equals(entry.getKey())) {
                    String[] temp = entry.getValue().split(",");
                    this.statusArray = new OrderStatus[temp.length];
                    int index = 0;
                    for (String name : temp) {
                        OrderStatus orderStatus;
                        this.statusArray[index] = orderStatus = OrderStatus.getInstance(name);
                        ++index;
                    }
                }
                if (PurgeCartVariableNames.NAME.toString().equals(entry.getKey())) {
                    this.nameArray = entry.getValue().split(",");
                }
                if (PurgeCartVariableNames.SECONDS_OLD.toString().equals(entry.getKey())) {
                    Long secondsOld = Long.parseLong(entry.getValue());
                    this.dateCreatedMinThreshold = new Date(SystemTime.asMillis() - secondsOld * 1000L);
                }
                if (!PurgeCartVariableNames.IS_PREVIEW.toString().equals(entry.getKey())) continue;
                this.isPreview = Boolean.parseBoolean(entry.getValue());
            }
            return this;
        }
    }
}

