/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.gateway;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayRollbackService;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.springframework.stereotype.Service;

@Service(value="blPassthroughPaymentRollbackService")
public class PassthroughPaymentRollbackServiceImpl
implements PaymentGatewayRollbackService {
    protected static final Log LOG = LogFactory.getLog(PassthroughPaymentRollbackServiceImpl.class);
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;

    public PaymentResponseDTO rollbackAuthorize(PaymentRequestDTO transactionToBeRolledBack) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Passthrough Payment Gateway - Rolling back authorize transaction with amount: " + transactionToBeRolledBack.getTransactionTotal()));
        }
        if (transactionToBeRolledBack.getAdditionalFields().containsKey("PASSTHROUGH_PAYMENT_TYPE")) {
            return new PaymentResponseDTO(PaymentType.getInstance((String)((String)transactionToBeRolledBack.getAdditionalFields().get("PASSTHROUGH_PAYMENT_TYPE"))), PaymentGatewayType.PASSTHROUGH).rawResponse("rollback authorize - successful").successful(true).paymentTransactionType(PaymentTransactionType.REVERSE_AUTH).amount(new Money(transactionToBeRolledBack.getTransactionTotal()));
        }
        throw new PaymentException("Make sure transaction contains a Passthrough Payment Type");
    }

    public PaymentResponseDTO rollbackCapture(PaymentRequestDTO transactionToBeRolledBack) throws PaymentException {
        throw new PaymentException("The Rollback Capture method is not supported for this module");
    }

    public PaymentResponseDTO rollbackAuthorizeAndCapture(PaymentRequestDTO transactionToBeRolledBack) throws PaymentException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Passthrough Payment Gateway - Rolling back authorize and capture transaction with amount: " + transactionToBeRolledBack.getTransactionTotal()));
        }
        if (transactionToBeRolledBack.getAdditionalFields().containsKey("PASSTHROUGH_PAYMENT_TYPE")) {
            return new PaymentResponseDTO(PaymentType.getInstance((String)((String)transactionToBeRolledBack.getAdditionalFields().get("PASSTHROUGH_PAYMENT_TYPE"))), PaymentGatewayType.PASSTHROUGH).rawResponse("rollback authorize and capture - successful").successful(true).paymentTransactionType(PaymentTransactionType.VOID).amount(new Money(transactionToBeRolledBack.getTransactionTotal()));
        }
        throw new PaymentException("Make sure transaction contains a Passthrough Payment Type");
    }

    public PaymentResponseDTO rollbackRefund(PaymentRequestDTO transactionToBeRolledBack) throws PaymentException {
        throw new PaymentException("The Rollback Refund method is not supported for this module");
    }
}

