/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrencyImpl;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentLogEventType;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.core.payment.domain.PaymentLog;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Deprecated
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PAYMENT_LOG")
public class PaymentLogImpl
implements PaymentLog {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentLogId")
    @GenericGenerator(name="PaymentLogId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="PaymentLogImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.PaymentLogImpl")})
    @Column(name="PAYMENT_LOG_ID")
    protected Long id;
    @Column(name="USER_NAME", nullable=false)
    @Index(name="PAYMENTLOG_USER_INDEX", columnNames={"USER_NAME"})
    @AdminPresentation(friendlyName="PaymentLogImpl_User_Name", order=1, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String userName;
    @Column(name="TRANSACTION_TIMESTAMP", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @AdminPresentation(friendlyName="PaymentLogImpl_Transaction_Time", order=3, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected Date transactionTimestamp;
    @Column(name="ORDER_PAYMENT_ID")
    @Index(name="PAYMENTLOG_ORDERPAYMENT_INDEX", columnNames={"ORDER_PAYMENT_ID"})
    @AdminPresentation(excluded=true, readOnly=true)
    protected Long orderPaymentId;
    @ManyToOne(targetEntity=CustomerImpl.class)
    @JoinColumn(name="CUSTOMER_ID")
    @Index(name="PAYMENTLOG_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Customer customer;
    @Column(name="ORDER_PAYMENT_REF_NUM")
    @Index(name="PAYMENTLOG_REFERENCE_INDEX", columnNames={"ORDER_PAYMENT_REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="PaymentLogImpl_Payment_Ref_Number", order=4, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String orderPaymentReferenceNumber;
    @Column(name="TRANSACTION_TYPE", nullable=false)
    @Index(name="PAYMENTLOG_TRANTYPE_INDEX", columnNames={"TRANSACTION_TYPE"})
    @AdminPresentation(friendlyName="PaymentLogImpl_Transaction_Type", order=5, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String transactionType;
    @Column(name="TRANSACTION_SUCCESS")
    @AdminPresentation(friendlyName="PaymentLogImpl_Transaction_Successfule", order=6, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected Boolean transactionSuccess = false;
    @Column(name="EXCEPTION_MESSAGE")
    @AdminPresentation(friendlyName="PaymentLogImpl_Exception_Message", order=7, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String exceptionMessage;
    @Column(name="LOG_TYPE", nullable=false)
    @Index(name="PAYMENTLOG_LOGTYPE_INDEX", columnNames={"LOG_TYPE"})
    @AdminPresentation(friendlyName="PaymentLogImpl_Type", order=8, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String logType;
    @Column(name="AMOUNT_PAID", precision=19, scale=5)
    @AdminPresentation(friendlyName="PaymentLogImpl_Amount", order=2, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected BigDecimal amountPaid;
    @ManyToOne(targetEntity=BroadleafCurrencyImpl.class)
    @JoinColumn(name="CURRENCY_CODE")
    @AdminPresentation(friendlyName="PaymentLogImpl_currency", order=2, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected BroadleafCurrency currency;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Date getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    @Override
    public void setTransactionTimestamp(Date transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
    }

    @Override
    public Long getPaymentInfoId() {
        return this.orderPaymentId;
    }

    @Override
    public void setPaymentInfoId(Long paymentInfoId) {
        this.orderPaymentId = paymentInfoId;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public String getPaymentInfoReferenceNumber() {
        return this.orderPaymentReferenceNumber;
    }

    @Override
    public void setPaymentInfoReferenceNumber(String paymentInfoReferenceNumber) {
        this.orderPaymentReferenceNumber = paymentInfoReferenceNumber;
    }

    @Override
    public PaymentTransactionType getTransactionType() {
        return PaymentTransactionType.getInstance((String)this.transactionType);
    }

    @Override
    public void setTransactionType(PaymentTransactionType transactionType) {
        this.transactionType = transactionType.getType();
    }

    @Override
    public PaymentLogEventType getLogType() {
        return PaymentLogEventType.getInstance((String)this.logType);
    }

    @Override
    public void setLogType(PaymentLogEventType logType) {
        this.logType = logType.getType();
    }

    @Override
    public Boolean getTransactionSuccess() {
        if (this.transactionSuccess == null) {
            return Boolean.FALSE;
        }
        return this.transactionSuccess;
    }

    @Override
    public void setTransactionSuccess(Boolean transactionSuccess) {
        this.transactionSuccess = transactionSuccess;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    public Money getAmountPaid() {
        return BroadleafCurrencyUtils.getMoney((BigDecimal)this.amountPaid, (BroadleafCurrency)this.currency);
    }

    @Override
    public void setAmountPaid(Money amountPaid) {
        this.amountPaid = Money.toAmount((Money)amountPaid);
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(BroadleafCurrency currency) {
        this.currency = currency;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        result = 31 * result + (this.orderPaymentId == null ? 0 : this.orderPaymentId.hashCode());
        result = 31 * result + (this.orderPaymentReferenceNumber == null ? 0 : this.orderPaymentReferenceNumber.hashCode());
        result = 31 * result + (this.transactionTimestamp == null ? 0 : this.transactionTimestamp.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PaymentLogImpl other = (PaymentLogImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        if (this.orderPaymentId == null ? other.orderPaymentId != null : !this.orderPaymentId.equals(other.orderPaymentId)) {
            return false;
        }
        if (this.orderPaymentReferenceNumber == null ? other.orderPaymentReferenceNumber != null : !this.orderPaymentReferenceNumber.equals(other.orderPaymentReferenceNumber)) {
            return false;
        }
        if (this.transactionTimestamp == null ? other.transactionTimestamp != null : !this.transactionTimestamp.equals(other.transactionTimestamp)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

