/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.vendor.service.exception.FulfillmentPriceException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.pricing.service.FulfillmentPricingService;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentEstimationResponse;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentPricingProvider;
import org.springframework.stereotype.Service;

@Service(value="blFulfillmentPricingService")
public class FulfillmentPricingServiceImpl
implements FulfillmentPricingService {
    protected static final Log LOG = LogFactory.getLog(FulfillmentPricingServiceImpl.class);
    @Resource(name="blFulfillmentPricingProviders")
    protected List<FulfillmentPricingProvider> providers;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @Override
    public FulfillmentGroup calculateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup) throws FulfillmentPriceException {
        if (fulfillmentGroup.getFulfillmentOption() == null) {
            fulfillmentGroup.setRetailFulfillmentPrice(Money.ZERO);
            fulfillmentGroup.setFulfillmentPrice(Money.ZERO);
            fulfillmentGroup.setSaleFulfillmentPrice(Money.ZERO);
            return fulfillmentGroup;
        }
        for (FulfillmentPricingProvider provider : this.providers) {
            if (!provider.canCalculateCostForFulfillmentGroup(fulfillmentGroup, fulfillmentGroup.getFulfillmentOption())) continue;
            return provider.calculateCostForFulfillmentGroup(fulfillmentGroup);
        }
        throw new FulfillmentPriceException("No valid processor was found to calculate the FulfillmentGroup cost with FulfillmentOption id: " + fulfillmentGroup.getFulfillmentOption().getId() + " and name: " + fulfillmentGroup.getFulfillmentOption().getName());
    }

    @Override
    public FulfillmentEstimationResponse estimateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup, Set<FulfillmentOption> options) throws FulfillmentPriceException {
        FulfillmentEstimationResponse response = new FulfillmentEstimationResponse();
        HashMap<? extends FulfillmentOption, Money> prices = new HashMap<FulfillmentOption, Money>();
        response.setFulfillmentOptionPrices(prices);
        for (FulfillmentPricingProvider provider : this.providers) {
            try {
                FulfillmentEstimationResponse processorResponse = provider.estimateCostForFulfillmentGroup(fulfillmentGroup, options);
                if (processorResponse == null || processorResponse.getFulfillmentOptionPrices() == null || processorResponse.getFulfillmentOptionPrices().size() <= 0) continue;
                prices.putAll(processorResponse.getFulfillmentOptionPrices());
            }
            catch (FulfillmentPriceException e) {
                String errorMessage = "FulfillmentPriceException thrown when trying to estimate fulfillment costs from ";
                errorMessage = errorMessage + provider.getClass().getName();
                errorMessage = errorMessage + ". Underlying message was: " + e.getMessage();
                LOG.error((Object)errorMessage);
            }
        }
        return response;
    }

    @Override
    public List<FulfillmentPricingProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<FulfillmentPricingProvider> providers) {
        this.providers = providers;
    }
}

