/*
 * Copyright 2008-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.broadleafcommerce.openadmin.client.dto;

import java.io.Serializable;

import com.google.gwt.user.client.rpc.IsSerializable;


/**
 * 
 * @author jfischer
 *
 */
public class ClassMetadata implements IsSerializable, Serializable {
	
	private static final long serialVersionUID = 1L;
	
	private String ceilingType;
	private ClassTree polymorphicEntities;
	private Property[] properties;
    private String currencyCode = "USD";
	
	public String getCeilingType() {
		return ceilingType;
	}
	
	public void setCeilingType(String type) {
		this.ceilingType = type;
	}

    public ClassTree getPolymorphicEntities() {
        return polymorphicEntities;
    }

    public void setPolymorphicEntities(ClassTree polymorphicEntities) {
        this.polymorphicEntities = polymorphicEntities;
    }

    public Property[] getProperties() {
		return properties;
	}
	
	public void setProperties(Property[] property) {
		this.properties = property;
	}

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
}
