/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PayPalPendingReasonType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PayPalPendingReasonType> TYPES = new HashMap<String, PayPalPendingReasonType>();
    public static final PayPalPendingReasonType NONE = new PayPalPendingReasonType("none", "none");
    public static final PayPalPendingReasonType ADDRESS = new PayPalPendingReasonType("address", "address");
    public static final PayPalPendingReasonType AUTHORIZATION = new PayPalPendingReasonType("authorization", "authorization");
    public static final PayPalPendingReasonType ECHECK = new PayPalPendingReasonType("echeck", "echeck");
    public static final PayPalPendingReasonType INTL = new PayPalPendingReasonType("intl", "intl");
    public static final PayPalPendingReasonType MULTICURRENCY = new PayPalPendingReasonType("multi-currency", "multi-currency");
    public static final PayPalPendingReasonType ORDER = new PayPalPendingReasonType("order", "order");
    public static final PayPalPendingReasonType PAYMENTREVIEW = new PayPalPendingReasonType("paymentreview", "paymentreview");
    public static final PayPalPendingReasonType UNILATERAL = new PayPalPendingReasonType("unilateral", "unilateral");
    public static final PayPalPendingReasonType VERIFY = new PayPalPendingReasonType("verify", "verify");
    public static final PayPalPendingReasonType OTHER = new PayPalPendingReasonType("other", "other");
    private String type;
    private String friendlyType;

    public static PayPalPendingReasonType getInstance(String type) {
        return TYPES.get(type);
    }

    public PayPalPendingReasonType() {
    }

    public PayPalPendingReasonType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPalPendingReasonType other = (PayPalPendingReasonType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

