/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PayPalReasonCodeType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PayPalReasonCodeType> TYPES = new HashMap<String, PayPalReasonCodeType>();
    public static final PayPalReasonCodeType NONE = new PayPalReasonCodeType("none", "none");
    public static final PayPalReasonCodeType CHARGEBACK = new PayPalReasonCodeType("chargeback", "chargeback");
    public static final PayPalReasonCodeType GUARANTEE = new PayPalReasonCodeType("guarantee", "guarantee");
    public static final PayPalReasonCodeType BUYERCOMPLAINT = new PayPalReasonCodeType("buyer-complaint", "buyer-complaint");
    public static final PayPalReasonCodeType REFUND = new PayPalReasonCodeType("refund", "refund");
    public static final PayPalReasonCodeType OTHER = new PayPalReasonCodeType("other", "other");
    private String type;
    private String friendlyType;

    public static PayPalReasonCodeType getInstance(String type) {
        return TYPES.get(type);
    }

    public PayPalReasonCodeType() {
    }

    public PayPalReasonCodeType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPalReasonCodeType other = (PayPalReasonCodeType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

