/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment;

import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.CompositePaymentService;
import org.broadleafcommerce.core.payment.service.PaymentInfoFactory;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.payment.service.workflow.CompositePaymentResponse;
import org.broadleafcommerce.payment.service.module.PayPalPaymentModule;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutService;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalPaymentInfoFactoryImpl;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundType;

public class PayPalCheckoutServiceImpl
implements PayPalCheckoutService {
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blCompositePaymentService")
    protected CompositePaymentService compositePaymentService;
    @Resource(name="blPayPalModule")
    protected PayPalPaymentModule payPalPaymentModule;

    @Override
    public CompositePaymentResponse initiateExpressCheckout(Order order) throws PaymentException {
        return this.compositePaymentService.executePaymentForGateway(order, (PaymentInfoFactory)new PayPalPaymentInfoFactoryImpl());
    }

    @Override
    public CheckoutResponse completeExpressCheckout(String token, String payerId, Order order) throws CheckoutException {
        CheckoutResponse checkoutResponse;
        PaymentResponseItem responseItem;
        PaymentInfo payPalPaymentInfo = null;
        PayPalDetailsRequest detailsRequest = new PayPalDetailsRequest();
        detailsRequest.setMethodType(PayPalMethodType.DETAILS);
        detailsRequest.setToken(token);
        try {
            PayPalDetailsResponse response = this.payPalPaymentModule.getExpressCheckoutDetails(detailsRequest);
            if (response != null && response.getPaymentDetails() != null && !order.getTotal().getAmount().equals(response.getPaymentDetails().getAmount().getAmount())) {
                throw new CheckoutException("The Order Total does not match the total from PayPal", null);
            }
        }
        catch (PaymentException e) {
            throw new CheckoutException("Unable to retrieve Express Checkout Details", (Throwable)e, null);
        }
        HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
        for (PaymentInfo paymentInfo : order.getPaymentInfos()) {
            if (!PaymentInfoType.PAYPAL.equals((Object)paymentInfo.getType())) continue;
            paymentInfo.getAdditionalFields().put("PAYERID", payerId);
            paymentInfo.getAdditionalFields().put("TOKEN", token);
            payments.put(paymentInfo, paymentInfo.createEmptyReferenced());
            payPalPaymentInfo = paymentInfo;
            break;
        }
        if ((responseItem = (PaymentResponseItem)(checkoutResponse = this.checkoutService.performCheckout(order, payments)).getPaymentResponse().getResponseItems().get(payPalPaymentInfo)).getTransactionSuccess().booleanValue()) {
            Customer customer = order.getCustomer();
            if (StringUtils.isEmpty((String)customer.getFirstName())) {
                customer.setFirstName(responseItem.getCustomer().getFirstName());
            }
            if (StringUtils.isEmpty((String)customer.getLastName())) {
                customer.setLastName(responseItem.getCustomer().getLastName());
            }
            if (StringUtils.isEmpty((String)customer.getEmailAddress())) {
                customer.setEmailAddress(responseItem.getCustomer().getEmailAddress());
            }
            this.customerService.saveCustomer(customer, false);
        }
        return checkoutResponse;
    }

    @Override
    public PayPalDetailsResponse getExpressCheckoutDetails(String token) throws PaymentException {
        PayPalDetailsRequest detailsRequest = new PayPalDetailsRequest();
        detailsRequest.setToken(token);
        detailsRequest.setMethodType(PayPalMethodType.DETAILS);
        return this.payPalPaymentModule.getExpressCheckoutDetails(detailsRequest);
    }

    @Override
    public CompositePaymentResponse refundTransaction(String transactionId, Order order) throws PaymentException {
        HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
        for (PaymentInfo paymentInfo : order.getPaymentInfos()) {
            if (!PaymentInfoType.PAYPAL.equals((Object)paymentInfo.getType())) continue;
            paymentInfo.getAdditionalFields().put("TRANSACTIONID", transactionId);
            paymentInfo.getAdditionalFields().put("REFUNDTYPE", PayPalRefundType.FULL.getType());
            payments.put(paymentInfo, paymentInfo.createEmptyReferenced());
            break;
        }
        return this.compositePaymentService.executePayment(order, payments);
    }
}

