/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class PayPalMethodType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PayPalMethodType> TYPES = new HashMap<String, PayPalMethodType>();
    public static final PayPalMethodType CHECKOUT = new PayPalMethodType("Checkout", "Checkout");
    public static final PayPalMethodType AUTHORIZATION = new PayPalMethodType("Authorization", "Authorization");
    public static final PayPalMethodType DETAILS = new PayPalMethodType("Details", "Details");
    public static final PayPalMethodType PROCESS = new PayPalMethodType("Process", "Process");
    public static final PayPalMethodType REFUND = new PayPalMethodType("Refund", "Refund");
    public static final PayPalMethodType CAPTURE = new PayPalMethodType("Capture", "Capture");
    public static final PayPalMethodType VOID = new PayPalMethodType("Void", "Void");
    private String type;
    private String friendlyType;

    public static PayPalMethodType getInstance(String type) {
        return TYPES.get(type);
    }

    public PayPalMethodType() {
    }

    public PayPalMethodType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PayPalMethodType other = (PayPalMethodType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

