/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.paypal.web.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.payment.service.workflow.CompositePaymentResponse;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutController;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalCheckoutService;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestParam;

public class BroadleafPayPalController
extends BroadleafCheckoutController {
    private static final Log LOG = LogFactory.getLog(BroadleafPayPalController.class);
    @Resource(name="blPayPalCheckoutService")
    protected PayPalCheckoutService payPalCheckoutService;

    public String paypalCheckout(HttpServletRequest request) throws PaymentException {
        Order cart = CartState.getCart();
        if (!(cart instanceof NullOrderImpl)) {
            CompositePaymentResponse compositePaymentResponse = this.payPalCheckoutService.initiateExpressCheckout(cart);
            for (PaymentInfo paymentInfo : compositePaymentResponse.getPaymentResponse().getResponseItems().keySet()) {
                PaymentResponseItem responseItem;
                if (!PaymentInfoType.PAYPAL.equals((Object)paymentInfo.getType()) || !(responseItem = (PaymentResponseItem)compositePaymentResponse.getPaymentResponse().getResponseItems().get(paymentInfo)).getTransactionSuccess().booleanValue()) continue;
                return "redirect:" + (String)responseItem.getAdditionalFields().get("REDIRECTURL");
            }
            if (LOG.isDebugEnabled() && compositePaymentResponse.getPaymentResponse().getResponseItems().size() == 0) {
                LOG.debug((Object)"Payment Response is empty. Please see BLC_PAYMENT_LOG and BLC_PAYMENT_RESPONSE_ITEM for further details.");
            }
        }
        return this.getCartPageRedirect();
    }

    public String paypalProcess(HttpServletRequest request, HttpServletResponse response, Model model, @RequestParam String token, @RequestParam(value="PayerID") String payerID) throws CheckoutException, PricingException {
        Order cart = CartState.getCart();
        if (!(cart instanceof NullOrderImpl)) {
            PaymentInfo payPalPaymentInfo = null;
            for (PaymentInfo paymentInfo : cart.getPaymentInfos()) {
                if (!PaymentInfoType.PAYPAL.equals((Object)paymentInfo.getType())) continue;
                payPalPaymentInfo = paymentInfo;
                paymentInfo.getAdditionalFields().put("PAYERID", payerID);
                paymentInfo.getAdditionalFields().put("TOKEN", token);
                break;
            }
            if (payPalPaymentInfo != null) {
                this.orderService.save(cart, Boolean.valueOf(false));
                this.initializeOrderForCheckout(cart);
                CheckoutResponse checkoutResponse = this.payPalCheckoutService.completeExpressCheckout(token, payerID, cart);
                PaymentResponseItem responseItem = (PaymentResponseItem)checkoutResponse.getPaymentResponse().getResponseItems().get(payPalPaymentInfo);
                if (!responseItem.getTransactionSuccess().booleanValue()) {
                    this.processFailedOrderCheckout(cart);
                    this.populateModelWithShippingReferenceData(request, model);
                    model.addAttribute("paymentException", (Object)true);
                    return this.getCheckoutView();
                }
                return this.getConfirmationView(checkoutResponse.getOrder().getOrderNumber());
            }
        }
        return this.getCartPageRedirect();
    }
}

