/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.module;

import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.vendor.service.exception.PaymentException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItemImpl;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.module.PaymentModule;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.vendor.paypal.service.payment.PayPalPaymentService;
import org.broadleafcommerce.vendor.paypal.service.payment.message.PayPalErrorResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.details.PayPalDetailsResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalItemRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalPaymentResponse;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalShippingRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.message.payment.PayPalSummaryRequest;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalMethodType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalRefundType;
import org.broadleafcommerce.vendor.paypal.service.payment.type.PayPalTransactionType;
import org.springframework.util.Assert;

public class PayPalPaymentModule
implements PaymentModule {
    protected PayPalPaymentService payPalPaymentService;

    public PaymentResponseItem authorize(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        return this.commonAuthorizeOrSale(paymentContext, PayPalTransactionType.AUTHORIZE);
    }

    public PaymentResponseItem reverseAuthorize(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        PayPalPaymentResponse response;
        PayPalPaymentRequest request = this.buildBasicRequest(paymentContext, PayPalTransactionType.REVERSEAUTHORIZE);
        request.setMethodType(PayPalMethodType.VOID);
        request.setCurrency(paymentContext.getPaymentInfo().getAmount().getCurrency().getCurrencyCode());
        Assert.isTrue((paymentContext.getPaymentInfo().getAdditionalFields().get("TRANSACTIONID") != null ? 1 : 0) != 0, (String)"The TRANSACTIONID value must be defined as an additional field in the PaymentInfo instance passed in.");
        request.setTransactionID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("TRANSACTIONID"));
        try {
            response = (PayPalPaymentResponse)this.payPalPaymentService.process(request);
        }
        catch (PaymentException e) {
            throw new org.broadleafcommerce.core.payment.service.exception.PaymentException((Throwable)e);
        }
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        this.setDecisionInformation(response, responseItem);
        responseItem.setAmountPaid(paymentContext.getPaymentInfo().getAmount());
        return responseItem;
    }

    public PaymentResponseItem debit(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        PayPalPaymentResponse response;
        PayPalPaymentRequest request = this.buildBasicRequest(paymentContext, PayPalTransactionType.CAPTURE);
        request.setMethodType(PayPalMethodType.CAPTURE);
        request.setCurrency(paymentContext.getPaymentInfo().getAmount().getCurrency().getCurrencyCode());
        Assert.isTrue((paymentContext.getPaymentInfo().getAdditionalFields().get("TRANSACTIONID") != null ? 1 : 0) != 0, (String)"The TRANSACTIONID value must be defined as an additional field in the PaymentInfo instance passed in.");
        request.setTransactionID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("TRANSACTIONID"));
        try {
            response = (PayPalPaymentResponse)this.payPalPaymentService.process(request);
        }
        catch (PaymentException e) {
            throw new org.broadleafcommerce.core.payment.service.exception.PaymentException((Throwable)e);
        }
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        this.setDecisionInformation(response, responseItem);
        responseItem.setAmountPaid(paymentContext.getPaymentInfo().getAmount());
        return responseItem;
    }

    public PaymentResponseItem authorizeAndDebit(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        return this.commonAuthorizeOrSale(paymentContext, PayPalTransactionType.AUTHORIZEANDCAPTURE);
    }

    public PaymentResponseItem credit(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        PayPalPaymentResponse response;
        PayPalPaymentRequest request = this.buildBasicRequest(paymentContext, PayPalTransactionType.CREDIT);
        request.setMethodType(PayPalMethodType.REFUND);
        request.setCurrency(paymentContext.getPaymentInfo().getAmount().getCurrency().getCurrencyCode());
        Assert.isTrue((paymentContext.getPaymentInfo().getAdditionalFields().get("REFUNDTYPE") != null ? 1 : 0) != 0, (String)"The REFUNDTYPE value must be defined as an additional field in the PaymentInfo instance passed in.");
        request.setRefundType(PayPalRefundType.getInstance((String)paymentContext.getPaymentInfo().getAdditionalFields().get("REFUNDTYPE")));
        Assert.isTrue((paymentContext.getPaymentInfo().getAdditionalFields().get("TRANSACTIONID") != null ? 1 : 0) != 0, (String)"The TRANSACTIONID value must be defined as an additional field in the PaymentInfo instance passed in.");
        request.setTransactionID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("TRANSACTIONID"));
        try {
            response = (PayPalPaymentResponse)this.payPalPaymentService.process(request);
        }
        catch (PaymentException e) {
            throw new org.broadleafcommerce.core.payment.service.exception.PaymentException((Throwable)e);
        }
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        this.setDecisionInformation(response, responseItem);
        this.setRefundInformation(response, responseItem);
        responseItem.setAmountPaid(paymentContext.getPaymentInfo().getAmount());
        return responseItem;
    }

    public PaymentResponseItem voidPayment(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        throw new org.broadleafcommerce.core.payment.service.exception.PaymentException("The void method is not supported by this module");
    }

    public PaymentResponseItem balance(PaymentContext paymentContext) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        throw new org.broadleafcommerce.core.payment.service.exception.PaymentException("The balance method is not supported by this module");
    }

    public PayPalDetailsResponse getExpressCheckoutDetails(PayPalDetailsRequest request) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        PayPalDetailsResponse response;
        try {
            response = (PayPalDetailsResponse)this.payPalPaymentService.process(request);
        }
        catch (PaymentException e) {
            throw new org.broadleafcommerce.core.payment.service.exception.PaymentException((Throwable)e);
        }
        return response;
    }

    public Boolean isValidCandidate(PaymentInfoType paymentType) {
        return PaymentInfoType.PAYPAL.equals((Object)paymentType);
    }

    protected PaymentResponseItem commonAuthorizeOrSale(PaymentContext paymentContext, PayPalTransactionType transactionType) throws org.broadleafcommerce.core.payment.service.exception.PaymentException {
        PayPalPaymentResponse response;
        PayPalPaymentRequest request = this.buildBasicRequest(paymentContext, transactionType);
        Assert.isTrue((boolean)paymentContext.getPaymentInfo().getAdditionalFields().containsKey("SUBTOTAL"), (String)"Must specify a SUBTOTAL value on the additionalFields of the PaymentInfo instance.");
        Assert.isTrue((boolean)paymentContext.getPaymentInfo().getAdditionalFields().containsKey("TOTALSHIPPING"), (String)"Must specify a TOTALSHIPPING value on the additionalFields of the PaymentInfo instance.");
        Assert.isTrue((boolean)paymentContext.getPaymentInfo().getAdditionalFields().containsKey("TOTALTAX"), (String)"Must specify a TOTALTAX value on the additionalFields of the PaymentInfo instance.");
        PaymentInfo paymentInfo = paymentContext.getPaymentInfo();
        PayPalSummaryRequest summaryRequest = request.getSummaryRequest();
        summaryRequest.setSubTotal(new Money((String)paymentInfo.getAdditionalFields().get("SUBTOTAL"), paymentInfo.getAmount().getCurrency().getCurrencyCode()));
        summaryRequest.setTotalShipping(new Money((String)paymentInfo.getAdditionalFields().get("TOTALSHIPPING"), paymentInfo.getAmount().getCurrency().getCurrencyCode()));
        summaryRequest.setTotalTax(new Money((String)paymentInfo.getAdditionalFields().get("TOTALTAX"), paymentInfo.getAmount().getCurrency().getCurrencyCode()));
        String token = (String)paymentContext.getPaymentInfo().getAdditionalFields().get("TOKEN");
        if (token == null) {
            if (PayPalTransactionType.AUTHORIZE.equals(transactionType)) {
                request.setMethodType(PayPalMethodType.AUTHORIZATION);
            } else {
                request.setMethodType(PayPalMethodType.CHECKOUT);
            }
        } else {
            request.setMethodType(PayPalMethodType.PROCESS);
            if (PayPalTransactionType.AUTHORIZE.equals(transactionType)) {
                request.setSecondaryMethodType(PayPalMethodType.AUTHORIZATION);
            } else {
                request.setSecondaryMethodType(PayPalMethodType.CHECKOUT);
            }
            request.setPayerID((String)paymentContext.getPaymentInfo().getAdditionalFields().get("PAYERID"));
            request.setToken(token);
        }
        request.setCurrency(paymentContext.getPaymentInfo().getAmount().getCurrency().getCurrencyCode());
        for (AmountItem amountItem : paymentContext.getPaymentInfo().getAmountItems()) {
            PayPalItemRequest itemRequest = new PayPalItemRequest();
            itemRequest.setDescription(amountItem.getDescription());
            itemRequest.setShortDescription(amountItem.getShortDescription());
            itemRequest.setQuantity(amountItem.getQuantity());
            itemRequest.setUnitPrice(new Money(amountItem.getUnitPrice()));
            itemRequest.setSystemId(amountItem.getSystemId());
            request.getItemRequests().add(itemRequest);
        }
        for (FulfillmentGroup fulfillmentGroup : paymentContext.getPaymentInfo().getOrder().getFulfillmentGroups()) {
            if (fulfillmentGroup.getAddress() == null) continue;
            PayPalShippingRequest shippingRequest = new PayPalShippingRequest();
            shippingRequest.setShipToName(fulfillmentGroup.getAddress().getFirstName() + " " + fulfillmentGroup.getAddress().getLastName());
            shippingRequest.setShipToStreet(fulfillmentGroup.getAddress().getAddressLine1());
            shippingRequest.setShipToStreet2(fulfillmentGroup.getAddress().getAddressLine2());
            shippingRequest.setShipToCity(fulfillmentGroup.getAddress().getCity());
            if (fulfillmentGroup.getAddress().getState() != null) {
                shippingRequest.setShipToState(fulfillmentGroup.getAddress().getState().getAbbreviation());
            }
            shippingRequest.setShipToZip(fulfillmentGroup.getAddress().getPostalCode());
            if (fulfillmentGroup.getAddress().getCountry() != null) {
                shippingRequest.setShipToCountryCode(fulfillmentGroup.getAddress().getCountry().getAbbreviation());
            }
            shippingRequest.setShipToPhoneNum(fulfillmentGroup.getAddress().getPrimaryPhone());
            request.getShippingRequests().add(shippingRequest);
        }
        try {
            response = (PayPalPaymentResponse)this.payPalPaymentService.process(request);
        }
        catch (PaymentException e) {
            throw new org.broadleafcommerce.core.payment.service.exception.PaymentException((Throwable)e);
        }
        PaymentResponseItem responseItem = this.buildBasicResponse(response);
        if (PayPalMethodType.PROCESS.equals(request.getMethodType())) {
            this.setDecisionInformation(response, responseItem);
        } else if (PayPalMethodType.CHECKOUT.equals(request.getMethodType()) || PayPalMethodType.AUTHORIZATION.equals(request.getMethodType())) {
            responseItem.getAdditionalFields().put("REDIRECTURL", response.getUserRedirectUrl());
        }
        responseItem.setAmountPaid(paymentContext.getPaymentInfo().getAmount());
        return responseItem;
    }

    protected void setDecisionInformation(PayPalPaymentResponse response, PaymentResponseItem responseItem) {
        responseItem.setTransactionId(response.getPaymentInfo().getTransactionId());
        if (response.getPaymentInfo().getParentTransactionId() != null) {
            responseItem.getAdditionalFields().put("PARENTTRANSACTIONID", response.getPaymentInfo().getParentTransactionId());
        }
        if (response.getPaymentInfo().getReceiptId() != null) {
            responseItem.getAdditionalFields().put("RECEIPTID", response.getPaymentInfo().getReceiptId());
        }
        if (response.getPaymentInfo().getExchangeRate() != null) {
            responseItem.getAdditionalFields().put("EXCHANGERATE", response.getPaymentInfo().getExchangeRate().toString());
        }
        if (response.getPaymentInfo().getPaymentStatusType() != null) {
            responseItem.getAdditionalFields().put("PAYMENTSTATUS", response.getPaymentInfo().getPaymentStatusType().getType());
        }
        if (response.getPaymentInfo().getPendingReasonType() != null) {
            responseItem.getAdditionalFields().put("PENDINGREASON", response.getPaymentInfo().getPendingReasonType().getType());
        }
        if (response.getPaymentInfo().getReasonCodeType() != null) {
            responseItem.getAdditionalFields().put("REASONCODE", response.getPaymentInfo().getReasonCodeType().getType());
        }
        if (response.getPaymentInfo().getHoldDecisionType() != null) {
            responseItem.getAdditionalFields().put("HOLDDECISION", response.getPaymentInfo().getHoldDecisionType().getType());
        }
        if (response.getPaymentInfo().getFeeAmount() != null) {
            responseItem.getAdditionalFields().put("FEEAMT", response.getPaymentInfo().getFeeAmount().toString());
        }
        if (response.getPaymentInfo().getSettleAmount() != null) {
            responseItem.getAdditionalFields().put("SETTLEAMT", response.getPaymentInfo().getSettleAmount().toString());
        }
        if (response.getPaymentInfo().getTaxAmount() != null) {
            responseItem.getAdditionalFields().put("TAXAMT", response.getPaymentInfo().getTaxAmount().toString());
        }
    }

    protected void setRefundInformation(PayPalPaymentResponse response, PaymentResponseItem responseItem) {
        if (response.getRefundInfo().getRefundTransactionId() != null) {
            responseItem.getAdditionalFields().put("REFUNDTRANSACTIONID", response.getRefundInfo().getRefundTransactionId());
        }
        if (response.getRefundInfo().getFeeRefundAmount() != null) {
            responseItem.getAdditionalFields().put("FEEREFUNDAMT", response.getRefundInfo().getFeeRefundAmount().toString());
        }
        if (response.getRefundInfo().getGrossRefundAmount() != null) {
            responseItem.getAdditionalFields().put("GROSSREFUNDAMT", response.getRefundInfo().getGrossRefundAmount().toString());
        }
        if (response.getRefundInfo().getNetRefundAmount() != null) {
            responseItem.getAdditionalFields().put("NETREFUNDAMT", response.getRefundInfo().getNetRefundAmount().toString());
        }
        if (response.getRefundInfo().getTotalRefundAmount() != null) {
            responseItem.getAdditionalFields().put("TOTALREFUNDEDAMT", response.getRefundInfo().getTotalRefundAmount().toString());
        }
        if (response.getRefundInfo().getRefundInfo() != null) {
            responseItem.getAdditionalFields().put("REFUNDINFO", response.getRefundInfo().getRefundInfo());
        }
        if (response.getRefundInfo().getRefundStatusType() != null) {
            responseItem.getAdditionalFields().put("REFUNDSTATUS", response.getRefundInfo().getRefundStatusType().getType());
        }
        if (response.getRefundInfo().getPendingReasonType() != null) {
            responseItem.getAdditionalFields().put("PENDINGREASON", response.getRefundInfo().getPendingReasonType().getType());
        }
    }

    protected PayPalPaymentRequest buildBasicRequest(PaymentContext paymentContext, PayPalTransactionType transactionType) {
        PayPalPaymentRequest request = new PayPalPaymentRequest();
        request.setTransactionType(transactionType);
        Assert.isTrue((paymentContext.getPaymentInfo().getReferenceNumber().length() <= 127 ? 1 : 0) != 0, (String)"The reference number for the paypal request cannot be greater than 127 characters");
        request.setReferenceNumber(paymentContext.getPaymentInfo().getReferenceNumber());
        PaymentInfo paymentInfo = paymentContext.getPaymentInfo();
        PayPalSummaryRequest summaryRequest = new PayPalSummaryRequest();
        summaryRequest.setGrandTotal(paymentInfo.getAmount());
        request.setSummaryRequest(summaryRequest);
        return request;
    }

    protected PaymentResponseItem buildBasicResponse(PayPalPaymentResponse response) {
        PaymentResponseItemImpl responseItem = new PaymentResponseItemImpl();
        responseItem.setTransactionTimestamp(SystemTime.asDate());
        responseItem.setReferenceNumber(response.getResponseToken());
        responseItem.setTransactionSuccess(Boolean.valueOf(response.isSuccessful()));
        responseItem.setAuthorizationCode(response.getAck());
        responseItem.setMiddlewareResponseCode(response.getAck());
        responseItem.setMiddlewareResponseText(response.getAck());
        int counter = 0;
        for (PayPalErrorResponse errorResponse : response.getErrorResponses()) {
            String errorCode = errorResponse.getErrorCode();
            if (counter == 0) {
                responseItem.setMiddlewareResponseCode(errorCode);
                responseItem.setMiddlewareResponseText(errorResponse.getLongMessage());
            }
            ++counter;
            responseItem.getAdditionalFields().put("MODULEERRORCODE", errorCode);
            responseItem.getAdditionalFields().put("MODULEERRORSEVERITYCODE_" + errorCode, errorResponse.getSeverityCode());
            responseItem.getAdditionalFields().put("MODULEERRORLONGMESSAGE_" + errorCode, errorResponse.getLongMessage());
            responseItem.getAdditionalFields().put("MODULEERRORSHORTMESSAGE_" + errorCode, errorResponse.getShortMessage());
        }
        responseItem.getAdditionalFields().putAll(response.getPassThroughErrors());
        return responseItem;
    }

    public PayPalPaymentService getPayPalPaymentService() {
        return this.payPalPaymentService;
    }

    public void setPayPalPaymentService(PayPalPaymentService payPalPaymentService) {
        this.payPalPaymentService = payPalPaymentService;
    }
}

