/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.service;

import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.service.LoginService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service(value="blLoginService")
public class LoginServiceImpl
implements LoginService {
    @Resource(name="blAuthenticationManager")
    private AuthenticationManager authenticationManager;
    @Resource(name="blUserDetailsService")
    private UserDetailsService userDetailsService;

    @Override
    public void loginCustomer(Customer customer) {
        UserDetails principal = this.userDetailsService.loadUserByUsername(customer.getUsername());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)principal, (Object)customer.getUnencodedPassword(), principal.getAuthorities());
        Authentication authentication = this.authenticationManager.authenticate((Authentication)token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }
}

