/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.controller;

import java.beans.PropertyEditor;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.profile.core.domain.ChallengeQuestion;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.ChallengeQuestionService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.controller.CustomChallengeQuestionEditor;
import org.broadleafcommerce.profile.web.controller.validator.RegisterCustomerValidator;
import org.broadleafcommerce.profile.web.core.form.RegisterCustomerForm;
import org.broadleafcommerce.profile.web.core.service.LoginService;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="blRegisterCustomerController")
@RequestMapping(value={"/registerCustomer"})
public class RegisterCustomerController {
    protected String displayRegistrationFormView;
    protected String registrationErrorView;
    protected String registrationSuccessView;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blRegisterCustomerValidator")
    protected RegisterCustomerValidator registerCustomerValidator;
    @Resource(name="blChallengeQuestionService")
    protected ChallengeQuestionService challengeQuestionService;
    @Resource(name="blLoginService")
    protected LoginService loginService;

    public RegisterCustomerController() {
        this.registrationErrorView = this.displayRegistrationFormView = "/account/registration/registerCustomer";
        this.registrationSuccessView = "redirect:/registerCustomer/registerCustomerSuccess.htm";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String registerCustomer() {
        return this.getDisplayRegistrationFormView();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView registerCustomer(@ModelAttribute(value="registerCustomerForm") RegisterCustomerForm registerCustomerForm, BindingResult errors, HttpServletRequest request) {
        this.registerCustomerValidator.validate(registerCustomerForm, (Errors)errors);
        if (!errors.hasErrors()) {
            this.customerService.registerCustomer(registerCustomerForm.getCustomer(), registerCustomerForm.getPassword(), registerCustomerForm.getPasswordConfirm());
            this.loginService.loginCustomer(registerCustomerForm.getCustomer());
            return new ModelAndView(this.getRegistrationSuccessView());
        }
        return new ModelAndView(this.getRegistrationErrorView());
    }

    @RequestMapping(method={RequestMethod.GET})
    public String registerCustomerSuccess() {
        return "/account/registration/registerCustomerSuccess";
    }

    @ModelAttribute(value="registerCustomerForm")
    public RegisterCustomerForm initCustomerRegistrationForm() {
        RegisterCustomerForm customerRegistrationForm = new RegisterCustomerForm();
        Customer customer = this.customerService.createCustomerFromId(null);
        customerRegistrationForm.setCustomer(customer);
        return customerRegistrationForm;
    }

    @ModelAttribute(value="challengeQuestions")
    public List<ChallengeQuestion> getChallengeQuestions() {
        return this.challengeQuestionService.readChallengeQuestions();
    }

    public String getRegistrationErrorView() {
        return this.registrationErrorView;
    }

    public void setRegistrationErrorView(String registrationErrorView) {
        this.registrationErrorView = registrationErrorView;
    }

    public String getRegistrationSuccessView() {
        return this.registrationSuccessView;
    }

    public void setRegistrationSuccessView(String registrationSuccessView) {
        this.registrationSuccessView = registrationSuccessView;
    }

    public RegisterCustomerValidator getRegisterCustomerValidator() {
        return this.registerCustomerValidator;
    }

    public void setRegisterCustomerValidator(RegisterCustomerValidator registerCustomerValidator) {
        this.registerCustomerValidator = registerCustomerValidator;
    }

    public String getDisplayRegistrationFormView() {
        return this.displayRegistrationFormView;
    }

    public void setDisplayRegistrationFormView(String displayRegistrationFormView) {
        this.displayRegistrationFormView = displayRegistrationFormView;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(ChallengeQuestion.class, (PropertyEditor)new CustomChallengeQuestionEditor(this.challengeQuestionService));
    }
}

