/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.security.CustomerStateFilter;
import org.springframework.core.Ordered;
import org.springframework.web.filter.GenericFilterBean;

public class RestApiCustomerStateFilter
extends GenericFilterBean
implements Ordered {
    @Resource(name="blCustomerService")
    private CustomerService customerService;
    private String customerIdAttributeName = "customerId";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String customerId = null;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (request.getAttribute(CustomerStateFilter.getCustomerRequestAttributeName()) == null) {
            Customer customer;
            if (request.getAttribute(this.customerIdAttributeName) != null) {
                customerId = String.valueOf(request.getAttribute(this.customerIdAttributeName));
            }
            if (customerId == null) {
                customerId = servletRequest.getParameter(this.customerIdAttributeName);
            }
            if (customerId == null) {
                customerId = request.getHeader(this.customerIdAttributeName);
            }
            if (customerId != null && customerId.trim().length() > 0 && (customer = this.customerService.readCustomerById(Long.valueOf(customerId))) != null) {
                servletRequest.setAttribute(CustomerStateFilter.getCustomerRequestAttributeName(), (Object)customer);
            }
        }
        filterChain.doFilter((ServletRequest)request, servletResponse);
    }

    public int getOrder() {
        return 2000;
    }

    public String getCustomerIdAttributeName() {
        return this.customerIdAttributeName;
    }

    public void setCustomerIdAttributeName(String customerIdAttributeName) {
        if (customerIdAttributeName == null || customerIdAttributeName.trim().length() < 1) {
            throw new IllegalArgumentException("customerIdAttributeName cannot be null");
        }
        this.customerIdAttributeName = customerIdAttributeName;
    }
}

