/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.email;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.email.service.EmailTrackingManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmailOpenTrackingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(EmailOpenTrackingServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getPathInfo();
        Long emailId = null;
        String imageUrl = "";
        if (url != null) {
            String[] items = url.split("/");
            emailId = Long.valueOf(items[1]);
            StringBuffer sb = new StringBuffer();
            for (int j = 2; j < items.length; ++j) {
                sb.append("/");
                sb.append(items[j]);
            }
            imageUrl = sb.toString();
        }
        if (emailId != null && !"null".equals(emailId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("service() => Recording Open for Email[" + emailId + "]"));
            }
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            EmailTrackingManager emailTrackingManager = (EmailTrackingManager)context.getBean("blEmailTrackingManager");
            String userAgent = request.getHeader("USER-AGENT");
            HashMap<String, String> extraValues = new HashMap<String, String>();
            extraValues.put("userAgent", userAgent);
            emailTrackingManager.recordOpen(emailId, extraValues);
        }
        if ("".equals(imageUrl)) {
            response.setContentType("image/gif");
            BufferedInputStream bis = null;
            ServletOutputStream out = response.getOutputStream();
            try {
                bis = new BufferedInputStream(EmailOpenTrackingServlet.class.getResourceAsStream("clear_dot.gif"));
                boolean eof = false;
                while (!eof) {
                    int temp = bis.read();
                    if (temp == -1) {
                        eof = true;
                        continue;
                    }
                    out.write(temp);
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Unable to close output stream in EmailOpenTrackingServlet", e);
                    }
                }
            }
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(imageUrl);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

