/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.service;

import javax.annotation.Resource;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.BroadleafWebRequestProcessor;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.service.LoginService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.WebRequest;

@Service(value="blLoginService")
public class LoginServiceImpl
implements LoginService {
    @Resource(name="blAuthenticationManager")
    private AuthenticationManager authenticationManager;
    @Resource(name="blUserDetailsService")
    private UserDetailsService userDetailsService;
    @Resource(name="blCartStateRequestProcessor")
    protected BroadleafWebRequestProcessor cartStateRequestProcessor;
    @Resource(name="blCustomerStateRequestProcessor")
    private BroadleafWebRequestProcessor customerStateRequestProcessor;

    @Override
    public Authentication loginCustomer(Customer customer) {
        return this.loginCustomer(customer.getUsername(), customer.getUnencodedPassword());
    }

    @Override
    public Authentication loginCustomer(String username, String clearTextPassword) {
        UserDetails principal = this.userDetailsService.loadUserByUsername(username);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)principal, (Object)clearTextPassword, principal.getAuthorities());
        Authentication authentication = this.authenticationManager.authenticate((Authentication)token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        this.customerStateRequestProcessor.process(this.getWebRequest());
        this.cartStateRequestProcessor.process(this.getWebRequest());
        return authentication;
    }

    @Override
    public void logoutCustomer() {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.customerStateRequestProcessor.process(this.getWebRequest());
        this.cartStateRequestProcessor.process(this.getWebRequest());
    }

    protected WebRequest getWebRequest() {
        return BroadleafRequestContext.getBroadleafRequestContext().getWebRequest();
    }
}

