/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.common.security.RandomGenerator;
import org.broadleafcommerce.common.security.util.CookieUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="blSessionFixationProtectionFilter")
public class SessionFixationProtectionFilter
extends GenericFilterBean {
    private static final Log LOG = LogFactory.getLog(SessionFixationProtectionFilter.class);
    protected static final String SESSION_ATTR = "SFP-ActiveID";
    @Resource(name="blSessionFixationEncryptionModule")
    protected EncryptionModule encryptionModule;
    @Resource(name="blCookieUtils")
    protected CookieUtils cookieUtils;

    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain chain) throws IOException, ServletException {
        String activeIdSessionValue;
        HttpServletRequest request = (HttpServletRequest)sRequest;
        HttpServletResponse response = (HttpServletResponse)sResponse;
        HttpSession session = request.getSession(false);
        if (SecurityContextHolder.getContext() == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        String string = activeIdSessionValue = session == null ? null : (String)session.getAttribute(SESSION_ATTR);
        if (StringUtils.isNotBlank((String)activeIdSessionValue) && request.isSecure()) {
            String activeIdCookieValue = this.cookieUtils.getCookieValue(request, "ActiveID");
            String decryptedActiveIdValue = this.encryptionModule.decrypt(activeIdCookieValue);
            if (!activeIdSessionValue.equals(decryptedActiveIdValue)) {
                this.abortUser(request, response);
                LOG.info((Object)"Session has been terminated. ActiveID did not match expected value.");
                return;
            }
        } else if (request.isSecure() && session != null) {
            String token;
            try {
                token = RandomGenerator.generateRandomId((String)"SHA1PRNG", (int)32);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
            String encryptedActiveIdValue = this.encryptionModule.encrypt(token);
            session.setAttribute(SESSION_ATTR, (Object)token);
            this.cookieUtils.setCookieValue(response, "ActiveID", encryptedActiveIdValue, "/", Integer.valueOf(-1), Boolean.valueOf(true));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void abortUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SecurityContextHolder.clearContext();
        this.cookieUtils.invalidateCookie(response, "ActiveID");
        this.cookieUtils.setCookieValue(response, "JSESSIONID", "-1", "/", Integer.valueOf(0), Boolean.valueOf(false));
        response.sendRedirect("/");
    }
}

