/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.security;

import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.util.BLCRequestUtils;
import org.broadleafcommerce.common.web.AbstractBroadleafWebRequestProcessor;
import org.broadleafcommerce.common.web.BroadleafRequestCustomerResolverImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.security.CustomerAuthenticatedFromCookieEvent;
import org.broadleafcommerce.profile.web.core.security.CustomerLoggedInEvent;
import org.broadleafcommerce.profile.web.core.security.CustomerMergeExtensionHandler;
import org.broadleafcommerce.profile.web.core.security.CustomerMergeExtensionManager;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.WebRequest;

@Component(value="blCustomerStateRequestProcessor")
public class CustomerStateRequestProcessor
extends AbstractBroadleafWebRequestProcessor
implements ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blCustomerMergeExtensionManager")
    protected CustomerMergeExtensionManager customerMergeExtensionManager;
    protected ApplicationEventPublisher eventPublisher;
    public static final String ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME = "_blc_anonymousCustomer";
    public static final String ANONYMOUS_CUSTOMER_ID_SESSION_ATTRIBUTE_NAME = "_blc_anonymousCustomerId";
    private static final String LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME = "_blc_lastPublishedEvent";
    public static final String OVERRIDE_CUSTOMER_SESSION_ATTR_NAME = "_blc_overrideCustomerId";
    public static final String ANONYMOUS_CUSTOMER_MERGED_SESSION_ATTRIBUTE_NAME = "_blc_anonymousCustomerMerged";

    public void process(WebRequest request) {
        Customer customer = null;
        Long overrideId = null;
        if (BLCRequestUtils.isOKtoUseSession((WebRequest)request)) {
            overrideId = (Long)request.getAttribute(OVERRIDE_CUSTOMER_SESSION_ATTR_NAME, 2);
        }
        if (overrideId != null) {
            customer = this.customerService.readCustomerById(overrideId);
        } else {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
                String userName = authentication.getName();
                customer = (Customer)BroadleafRequestCustomerResolverImpl.getRequestCustomerResolver().getCustomer(request);
                if (!(userName == null || customer != null && userName.equals(customer.getUsername()))) {
                    customer = this.customerService.readCustomerByUsername(userName);
                    if (this.logger.isDebugEnabled() && customer != null) {
                        this.logger.debug((Object)("Customer found by username " + userName));
                    }
                }
                if (customer != null) {
                    ApplicationEvent lastPublishedEvent = (ApplicationEvent)request.getAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, 0);
                    if (authentication instanceof RememberMeAuthenticationToken) {
                        CustomerAuthenticatedFromCookieEvent cookieEvent;
                        customer.setCookied(true);
                        boolean publishRememberMeEvent = true;
                        if (lastPublishedEvent != null && lastPublishedEvent instanceof CustomerAuthenticatedFromCookieEvent && userName.equals((cookieEvent = (CustomerAuthenticatedFromCookieEvent)lastPublishedEvent).getCustomer().getUsername())) {
                            publishRememberMeEvent = false;
                        }
                        if (publishRememberMeEvent) {
                            cookieEvent = new CustomerAuthenticatedFromCookieEvent(customer, ((Object)((Object)this)).getClass().getName());
                            this.eventPublisher.publishEvent((ApplicationEvent)cookieEvent);
                            request.setAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, (Object)cookieEvent, 0);
                        }
                    } else if (authentication instanceof UsernamePasswordAuthenticationToken) {
                        CustomerLoggedInEvent loggedInEvent;
                        customer.setLoggedIn(true);
                        boolean publishLoggedInEvent = true;
                        if (lastPublishedEvent != null && lastPublishedEvent instanceof CustomerLoggedInEvent && userName.equals((loggedInEvent = (CustomerLoggedInEvent)lastPublishedEvent).getCustomer().getUsername())) {
                            publishLoggedInEvent = false;
                        }
                        if (publishLoggedInEvent) {
                            loggedInEvent = new CustomerLoggedInEvent(customer, ((Object)((Object)this)).getClass().getName());
                            this.eventPublisher.publishEvent((ApplicationEvent)loggedInEvent);
                            request.setAttribute(LAST_PUBLISHED_EVENT_SESSION_ATTRIBUTED_NAME, (Object)loggedInEvent, 0);
                        }
                    } else {
                        customer = this.resolveAuthenticatedCustomer(authentication);
                    }
                }
            }
        }
        customer = customer == null ? this.resolveAnonymousCustomer(request) : this.mergeCustomerIfRequired(request, customer);
        CustomerState.setCustomer(customer);
        HashMap<String, Customer> ruleMap = (HashMap<String, Customer>)request.getAttribute(BLC_RULE_MAP_PARAM, 0);
        if (ruleMap == null) {
            ruleMap = new HashMap<String, Customer>();
        }
        ruleMap.put("customer", customer);
        request.setAttribute(BLC_RULE_MAP_PARAM, ruleMap, 0);
    }

    protected Customer mergeCustomerIfRequired(WebRequest request, Customer customer) {
        if (BLCRequestUtils.isOKtoUseSession((WebRequest)request) && request.getAttribute(CustomerStateRequestProcessor.getAnonymousCustomerMergedSessionAttributeName(), 2) == null) {
            request.setAttribute(CustomerStateRequestProcessor.getAnonymousCustomerMergedSessionAttributeName(), (Object)Boolean.TRUE, 2);
            Customer anonymousCustomer = this.getAnonymousCustomer(request);
            customer = this.copyAnonymousCustomerInfoToCustomer(request, anonymousCustomer, customer);
        }
        return customer;
    }

    protected Customer copyAnonymousCustomerInfoToCustomer(WebRequest request, Customer anonymous, Customer customer) {
        if (this.customerMergeExtensionManager != null) {
            ExtensionResultHolder resultHolder = new ExtensionResultHolder();
            resultHolder.setResult((Object)customer);
            ((CustomerMergeExtensionHandler)this.customerMergeExtensionManager.getProxy()).merge((ExtensionResultHolder<Customer>)resultHolder, request, anonymous);
            if (resultHolder.getThrowable() != null) {
                if (resultHolder.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)resultHolder.getThrowable();
                }
                throw new RuntimeException("An unexpected error occured merging the anonymous customer", resultHolder.getThrowable());
            }
            return this.customerService.saveCustomer((Customer)resultHolder.getResult());
        }
        return customer;
    }

    public Customer resolveAuthenticatedCustomer(Authentication authentication) {
        return null;
    }

    public Customer resolveAnonymousCustomer(WebRequest request) {
        Customer customer = this.getAnonymousCustomer(request);
        if (customer == null) {
            customer = this.customerService.createNewCustomer();
            if (BLCRequestUtils.isOKtoUseSession((WebRequest)request)) {
                request.setAttribute(CustomerStateRequestProcessor.getAnonymousCustomerSessionAttributeName(), (Object)customer, 2);
            }
        }
        customer.setAnonymous(true);
        return customer;
    }

    public Customer getAnonymousCustomer(WebRequest request) {
        if (BLCRequestUtils.isOKtoUseSession((WebRequest)request)) {
            Long customerId;
            Customer anonymousCustomer = (Customer)request.getAttribute(CustomerStateRequestProcessor.getAnonymousCustomerSessionAttributeName(), 2);
            if (anonymousCustomer == null && (customerId = (Long)request.getAttribute(CustomerStateRequestProcessor.getAnonymousCustomerIdSessionAttributeName(), 2)) != null) {
                anonymousCustomer = this.customerService.readCustomerById(customerId);
            }
            return anonymousCustomer;
        }
        return null;
    }

    public static String getAnonymousCustomerSessionAttributeName() {
        return ANONYMOUS_CUSTOMER_SESSION_ATTRIBUTE_NAME;
    }

    public static String getAnonymousCustomerIdSessionAttributeName() {
        return ANONYMOUS_CUSTOMER_ID_SESSION_ATTRIBUTE_NAME;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public static String getCustomerRequestAttributeName() {
        return BroadleafRequestCustomerResolverImpl.getRequestCustomerResolver().getCustomerRequestAttributeName();
    }

    public static String getAnonymousCustomerMergedSessionAttributeName() {
        return ANONYMOUS_CUSTOMER_MERGED_SESSION_ATTRIBUTE_NAME;
    }
}

