/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.email;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.email.service.EmailTrackingManager;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;

public class EmailClickTrackingFilter
implements Filter {
    private EmailTrackingManager emailTrackingManager;
    @Resource(name="blCustomerState")
    protected CustomerState customerState;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String emailId = request.getParameter("email_id");
        if (emailId != null) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            Enumeration names = request.getParameterNames();
            String customerId = request.getParameter("customerId");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if ("customerId".equals(name)) continue;
                parameterMap.put(name, request.getParameter(name));
            }
            if (customerId == null) {
                Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
                if (customer != null && customer.getId() != null) {
                    customerId = customer.getId().toString();
                }
            }
            HashMap<String, String> extraValues = new HashMap<String, String>();
            extraValues.put("requestUri", ((HttpServletRequest)request).getRequestURI());
            this.emailTrackingManager.recordClick(Long.valueOf(emailId), parameterMap, customerId, extraValues);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public EmailTrackingManager getEmailTrackingManager() {
        return this.emailTrackingManager;
    }

    public void setEmailTrackingManager(EmailTrackingManager emailTrackingManager) {
        this.emailTrackingManager = emailTrackingManager;
    }
}

