/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core;

import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPersistedEvent;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.security.CustomerStateRequestProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.WebRequest;

@Component(value="blCustomerStateRefresher")
public class CustomerStateRefresher
implements ApplicationListener<CustomerPersistedEvent> {
    public void onApplicationEvent(CustomerPersistedEvent event) {
        Customer dbCustomer = event.getCustomer();
        WebRequest request = BroadleafRequestContext.getBroadleafRequestContext().getWebRequest();
        if (request != null) {
            String customerAttribute = CustomerStateRequestProcessor.getAnonymousCustomerSessionAttributeName();
            String customerIdAttribute = CustomerStateRequestProcessor.getAnonymousCustomerIdSessionAttributeName();
            Customer sessionCustomer = (Customer)request.getAttribute(customerAttribute, 2);
            if (sessionCustomer != null && sessionCustomer.getId().equals(dbCustomer.getId())) {
                request.removeAttribute(customerAttribute, 2);
                request.setAttribute(customerIdAttribute, (Object)dbCustomer.getId(), 2);
            }
            if (CustomerState.getCustomer() != null && CustomerState.getCustomer().getId().equals(dbCustomer.getId())) {
                Customer preMergedCustomer = CustomerState.getCustomer();
                this.resetTransientFields(preMergedCustomer, dbCustomer);
                CustomerState.setCustomer(dbCustomer);
            }
        }
    }

    protected void resetTransientFields(Customer preMergedCustomer, Customer postMergedCustomer) {
        postMergedCustomer.setUnencodedPassword(preMergedCustomer.getUnencodedPassword());
        postMergedCustomer.setUnencodedChallengeAnswer(preMergedCustomer.getUnencodedChallengeAnswer());
        postMergedCustomer.setAnonymous(preMergedCustomer.isAnonymous());
        postMergedCustomer.setCookied(preMergedCustomer.isCookied());
        postMergedCustomer.setLoggedIn(preMergedCustomer.isLoggedIn());
    }
}

