/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.message.v2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import noNamespace.ErrorDocument;
import noNamespace.ErrorV2Type;
import noNamespace.LocationV3Type;
import noNamespace.PostageV2Type;
import noNamespace.RateV2ResponseDocument;
import noNamespace.RateV2ResponseType;
import noNamespace.ResponsePackageV2Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItem;
import org.broadleafcommerce.vendor.usps.service.message.USPSLocation;
import org.broadleafcommerce.vendor.usps.service.message.USPSPostage;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceResponse;
import org.broadleafcommerce.vendor.usps.service.type.USPSServiceResponseType;

public class USPSResponseBuilder
implements org.broadleafcommerce.vendor.usps.service.message.USPSResponseBuilder {
    private static final Log LOG = LogFactory.getLog(USPSResponseBuilder.class);

    @Override
    public USPSShippingPriceResponse buildResponse(InputStream hostInput, USPSShippingPriceRequest request) {
        ResponsePackageV2Type[] packages;
        RateV2ResponseDocument doc;
        USPSShippingPriceResponse shippingPriceResponse = new USPSShippingPriceResponse();
        String xml = null;
        try {
            xml = this.generateXml(hostInput);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Host Response: " + xml));
            }
            doc = RateV2ResponseDocument.Factory.parse((String)xml);
        }
        catch (XmlException e) {
            if (xml != null) {
                try {
                    ErrorDocument error = ErrorDocument.Factory.parse((String)xml);
                    ErrorV2Type errorType = error.getError();
                    shippingPriceResponse.setErrorDetected(true);
                    shippingPriceResponse.setErrorCode(String.valueOf(errorType.getNumber()));
                    shippingPriceResponse.setErrorText(errorType.getDescription());
                    return shippingPriceResponse;
                }
                catch (XmlException e1) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RateV2ResponseType responseType = doc.getRateV2Response();
        for (ResponsePackageV2Type packageItem : packages = responseType.getPackageArray()) {
            PostageV2Type[] postages;
            String id = packageItem.getID();
            USPSContainerItem key = new USPSContainerItem();
            key.setPackageId(id);
            USPSContainerItem originalItem = (USPSContainerItem)request.getContainerItems().get(request.getContainerItems().indexOf(key));
            shippingPriceResponse.getResponses().push(originalItem);
            if (packageItem.getError() != null) {
                shippingPriceResponse.setErrorDetected(true);
                originalItem.setErrorDetected(true);
                originalItem.setErrorCode(packageItem.getError().getSource());
                originalItem.setErrorText(packageItem.getError().getDescription());
            }
            originalItem.setZone(packageItem.getZone());
            if (packageItem.xgetRestrictions() != null) {
                originalItem.setRestrictions(packageItem.getRestrictions());
            }
            for (PostageV2Type postage : postages = packageItem.getPostageArray()) {
                USPSServiceResponseType shippingMethod = USPSServiceResponseType.getInstanceByDescription(postage.getMailService());
                if (shippingMethod == null) {
                    LOG.warn((Object)("Unable to identify shipping method based on description: " + postage.getMailService() + ". Skipping this postage element."));
                    continue;
                }
                USPSPostage uspsPostage = new USPSPostage();
                uspsPostage.setRate(new Money((double)postage.getRate()));
                originalItem.getPostage().put(shippingMethod, uspsPostage);
            }
        }
        return shippingPriceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXml(InputStream hostInput) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean eof = false;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(hostInput));
            while (!eof) {
                String temp = reader.readLine();
                if (temp == null) {
                    eof = true;
                    continue;
                }
                sb.append(temp);
                sb.append("\n");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {}
            }
        }
        return sb.toString();
    }

    public void buildLocations(List<USPSLocation> uspsLocations, LocationV3Type[] locations) {
        for (LocationV3Type location : locations) {
            USPSLocation uspsLocation = new USPSLocation();
            uspsLocation.setCity(location.getCity());
            uspsLocation.setCutoff(location.getCutOff());
            uspsLocation.setFacility(location.getFacility());
            uspsLocation.setState(location.getState());
            uspsLocation.setStreet(location.getStreet());
            uspsLocation.setZip(location.getZip());
            uspsLocations.add(uspsLocation);
        }
    }
}

