/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service.module;

import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.order.service.type.USPSServiceMethod;
import org.broadleafcommerce.pricing.service.module.USPSShippingCalculationModule;
import org.broadleafcommerce.profile.vendor.service.exception.ShippingPriceException;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItem;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerShapeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerSizeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSFirstClassType;
import org.broadleafcommerce.vendor.usps.service.type.USPSServiceType;

public class USPSSingleItemPerPackageShippingCalculationModule
extends USPSShippingCalculationModule {
    @Override
    protected List<USPSContainerItemRequest> createPackages(FulfillmentGroup fulfillmentGroup) throws ShippingPriceException {
        ArrayList<USPSContainerItemRequest> itemRequests = new ArrayList<USPSContainerItemRequest>();
        for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
            ArrayList<DiscreteOrderItem> discreteItems = new ArrayList<DiscreteOrderItem>();
            OrderItem orderItem = fgItem.getOrderItem();
            if (BundleOrderItem.class.isAssignableFrom(orderItem.getClass())) {
                discreteItems.addAll(((BundleOrderItem)orderItem).getDiscreteOrderItems());
            } else {
                if (GiftWrapOrderItem.class.isAssignableFrom(orderItem.getClass())) {
                    List wrappedItems = ((GiftWrapOrderItem)orderItem).getWrappedItems();
                    if (fulfillmentGroup.getOrder().getOrderItems().containsAll(wrappedItems)) continue;
                    throw new ShippingPriceException("To price shipping correctly, the items contained in the GiftWrapOrderItem must also individually appear in the order, not just in the wrappedItems collection of GiftWrapOrderItem.");
                }
                if (DiscreteOrderItem.class.isAssignableFrom(orderItem.getClass())) {
                    discreteItems.add((DiscreteOrderItem)orderItem);
                }
            }
            int counter = 0;
            for (DiscreteOrderItem discreteItem : discreteItems) {
                itemRequests.add(this.createRequest(fulfillmentGroup, discreteItem, counter));
                ++counter;
            }
        }
        return itemRequests;
    }

    public String getServiceName() {
        return ShippingServiceType.USPS.getType();
    }

    protected USPSContainerItemRequest createRequest(FulfillmentGroup fulfillmentGroup, DiscreteOrderItem discreteItem, int counter) throws ShippingPriceException {
        String method = fulfillmentGroup.getMethod();
        String[] methods = method.split("_");
        USPSServiceMethod uspsMethod = USPSServiceMethod.getInstance(methods[0]);
        if (uspsMethod == null) {
            throw new ShippingPriceException("Unable to find a USPSShippingMethod for the method found on the fulfillment group: (" + fulfillmentGroup.getMethod() + ")");
        }
        USPSServiceType serviceType = USPSServiceType.getInstanceByServiceMethod(uspsMethod);
        if (serviceType == null) {
            throw new ShippingPriceException("Unable to establish a USPSServiceType for the USPSServiceMethod: (" + uspsMethod.getType() + ")");
        }
        USPSContainerItem itemRequest = new USPSContainerItem();
        itemRequest.setService(serviceType);
        Product product = discreteItem.getProduct();
        itemRequest.setContainerSize((USPSContainerSizeType)product.getSize());
        itemRequest.setContainerShape((USPSContainerShapeType)product.getContainer());
        itemRequest.setDepth(product.getDepth());
        itemRequest.setDimensionUnitOfMeasureType(product.getDimension().getDimensionUnitOfMeasure());
        if (serviceType.equals(USPSServiceType.FIRSTCLASS) && methods.length > 1) {
            itemRequest.setFirstClassType(USPSFirstClassType.getInstance(methods[1]));
        }
        itemRequest.setGirth(product.getGirth());
        itemRequest.setHeight(product.getHeight());
        if (serviceType.equals(USPSServiceType.ALL) || serviceType.equals(USPSServiceType.PARCEL) || serviceType.equals(USPSServiceType.ONLINE) || serviceType.equals(USPSServiceType.FIRSTCLASS) && (itemRequest.getFirstClassType().equals(USPSFirstClassType.LETTER) || itemRequest.getFirstClassType().equals(USPSFirstClassType.FLAT))) {
            itemRequest.setMachineSortable(product.isMachineSortable());
        }
        itemRequest.setPackageId(String.valueOf(counter));
        itemRequest.setWeight(product.getWeight().getWeight());
        itemRequest.setWeightUnitOfMeasureType(product.getWeight().getWeightUnitOfMeasure());
        itemRequest.setWidth(product.getWidth());
        itemRequest.setZipDestination(fulfillmentGroup.getAddress().getPostalCode());
        itemRequest.setZipOrigination(this.getOriginationPostalCode());
        return itemRequest;
    }
}

