/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.message.v2;

import java.math.BigDecimal;
import org.broadleafcommerce.profile.util.UnitOfMeasureUtil;
import org.broadleafcommerce.profile.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.profile.vendor.service.exception.ShippingPriceException;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSVersionedRequestValidator;
import org.broadleafcommerce.vendor.usps.service.type.USPSServiceType;
import org.broadleafcommerce.vendor.usps.service.type.USPSShippingPriceErrorCode;

public class USPSRequestValidator
implements USPSVersionedRequestValidator {
    @Override
    public void validateService(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if (!(itemRequest.getService().equals(USPSServiceType.ALL) || itemRequest.getService().equals(USPSServiceType.FIRSTCLASS) || itemRequest.getService().equals(USPSServiceType.PRIORITY) || itemRequest.getService().equals(USPSServiceType.EXPRESS) || itemRequest.getService().equals(USPSServiceType.BPM) || itemRequest.getService().equals(USPSServiceType.PARCEL) || itemRequest.getService().equals(USPSServiceType.MEDIA) || itemRequest.getService().equals(USPSServiceType.LIBRARY))) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.SERVICENOTSUPPORTED.getType(), USPSShippingPriceErrorCode.SERVICENOTSUPPORTED.getMessage());
        }
    }

    @Override
    public void validateWeight(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        USPSServiceType service = itemRequest.getService();
        if (service.equals(USPSServiceType.FIRSTCLASS) && UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > UnitOfMeasureUtil.convertOuncesToPounds((BigDecimal)BigDecimal.valueOf(13L)).doubleValue()) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.OVERWEIGHT.getType(), USPSShippingPriceErrorCode.OVERWEIGHT.getMessage());
        }
        if (service.equals(USPSServiceType.BPM) && UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > 15.0) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.OVERWEIGHT.getType(), USPSShippingPriceErrorCode.OVERWEIGHT.getMessage());
        }
        if (UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > 70.0) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.OVERWEIGHT.getType(), USPSShippingPriceErrorCode.OVERWEIGHT.getMessage());
        }
    }

    @Override
    public void validateSize(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if (itemRequest.getContainerSize() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.SIZENOTSPECIFIED.getType(), USPSShippingPriceErrorCode.SIZENOTSPECIFIED.getMessage());
        }
    }

    @Override
    public void validateContainer(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if ((itemRequest.getService().equals(USPSServiceType.EXPRESS) || itemRequest.getService().equals(USPSServiceType.PRIORITY)) && itemRequest.getContainerShape() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.SHAPENOTSPECIFIED.getType(), USPSShippingPriceErrorCode.SHAPENOTSPECIFIED.getMessage());
        }
    }

    @Override
    public void validateMachinable(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if ((itemRequest.getService().equals(USPSServiceType.ALL) || itemRequest.getService().equals(USPSServiceType.ONLINE) || itemRequest.getService().equals(USPSServiceType.PARCEL)) && itemRequest.isMachineSortable() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.MACHINABLESPECIFIED.getType(), USPSShippingPriceErrorCode.MACHINABLESPECIFIED.getMessage());
        }
    }

    @Override
    public void validateDimensions(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
    }

    @Override
    public void validateGirth(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
    }

    @Override
    public void validateShipDate(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
    }

    @Override
    public void validateOther(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
    }
}

