/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlTokenSource;
import org.broadleafcommerce.profile.vendor.service.AbstractVendorService;
import org.broadleafcommerce.profile.vendor.service.exception.ShippingPriceException;
import org.broadleafcommerce.profile.vendor.service.exception.ShippingPriceHostException;
import org.broadleafcommerce.profile.vendor.service.message.ShippingPriceResponse;
import org.broadleafcommerce.profile.vendor.service.monitor.ServiceStatusDetectable;
import org.broadleafcommerce.profile.vendor.service.type.ServiceStatusType;
import org.broadleafcommerce.vendor.usps.service.USPSShippingCalculationService;
import org.broadleafcommerce.vendor.usps.service.message.USPSRequestBuilder;
import org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator;
import org.broadleafcommerce.vendor.usps.service.message.USPSResponseBuilder;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceResponse;

public class USPSShippingCalculationServiceImpl
extends AbstractVendorService
implements ServiceStatusDetectable,
USPSShippingCalculationService {
    private static final Log LOG = LogFactory.getLog(USPSShippingCalculationServiceImpl.class);
    protected String uspsCharSet;
    protected String uspsPassword;
    protected String uspsServerName;
    protected String uspsServiceAPI;
    protected String uspsUserName;
    protected String httpProtocol;
    protected Integer failureReportingThreshold;
    protected Integer failureCount = 0;
    protected Boolean isUp = true;
    protected String uspsShippingAPI;
    protected String rateRequestElement;
    protected USPSRequestValidator uspsRequestValidator;
    protected USPSRequestBuilder uspsRequestBuilder;
    protected USPSResponseBuilder uspsResponseBuilder;

    @Override
    public USPSShippingPriceResponse retrieveShippingRates(USPSShippingPriceRequest request) throws ShippingPriceException {
        this.uspsRequestValidator.validateRequest(request);
        USPSShippingPriceResponse shippingPriceResponse = new USPSShippingPriceResponse();
        InputStream response = null;
        try {
            response = this.callUSPSPricingCalculation(request);
            shippingPriceResponse = this.uspsResponseBuilder.buildResponse(response, request);
        }
        catch (Exception e) {
            this.incrementFailure();
            throw new ShippingPriceException((Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"IOException while closing the InputStream", (Throwable)e);
                }
            }
        }
        this.clearStatus();
        if (shippingPriceResponse.isErrorDetected()) {
            ShippingPriceHostException e = new ShippingPriceHostException();
            e.setShippingPriceResponse((ShippingPriceResponse)shippingPriceResponse);
            throw e;
        }
        return shippingPriceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearStatus() {
        Integer n = this.failureCount;
        synchronized (n) {
            this.isUp = true;
            this.failureCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementFailure() {
        Integer n = this.failureCount;
        synchronized (n) {
            if (this.failureCount >= this.failureReportingThreshold) {
                this.isUp = false;
            } else {
                Integer n2 = this.failureCount;
                Integer n3 = this.failureCount = Integer.valueOf(this.failureCount + 1);
            }
        }
    }

    protected InputStream callUSPSPricingCalculation(USPSShippingPriceRequest request) throws IOException {
        URL contentURL = new URL(new StringBuffer(this.httpProtocol).append("://").append(this.uspsServerName).append(this.uspsServiceAPI).toString());
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("API", this.uspsShippingAPI);
        XmlTokenSource doc = this.uspsRequestBuilder.buildRequest(request, this.uspsUserName, this.uspsPassword);
        String text = doc.xmlText();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("xml request source: " + text));
        }
        content.put("XML", text);
        return this.postMessage(content, contentURL, this.uspsCharSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceStatusType getServiceStatus() {
        Integer n = this.failureCount;
        synchronized (n) {
            if (this.isUp.booleanValue()) {
                return ServiceStatusType.UP;
            }
            return ServiceStatusType.DOWN;
        }
    }

    @Override
    public String getUspsCharSet() {
        return this.uspsCharSet;
    }

    @Override
    public void setUspsCharSet(String uspsCharSet) {
        this.uspsCharSet = uspsCharSet;
    }

    @Override
    public String getUspsPassword() {
        return this.uspsPassword;
    }

    @Override
    public void setUspsPassword(String uspsPassword) {
        this.uspsPassword = uspsPassword;
    }

    @Override
    public String getUspsServerName() {
        return this.uspsServerName;
    }

    @Override
    public void setUspsServerName(String uspsServerName) {
        this.uspsServerName = uspsServerName;
    }

    @Override
    public String getUspsServiceAPI() {
        return this.uspsServiceAPI;
    }

    @Override
    public void setUspsServiceAPI(String uspsServiceAPI) {
        this.uspsServiceAPI = uspsServiceAPI;
    }

    @Override
    public String getUspsUserName() {
        return this.uspsUserName;
    }

    @Override
    public void setUspsUserName(String uspsUserName) {
        this.uspsUserName = uspsUserName;
    }

    @Override
    public String getHttpProtocol() {
        return this.httpProtocol;
    }

    @Override
    public void setHttpProtocol(String httpProtocol) {
        this.httpProtocol = httpProtocol;
    }

    @Override
    public Integer getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    @Override
    public void setFailureReportingThreshold(Integer failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    @Override
    public String getServiceName() {
        return this.getClass().getName();
    }

    @Override
    public String getUspsShippingAPI() {
        return this.uspsShippingAPI;
    }

    @Override
    public void setUspsShippingAPI(String uspsShippingAPI) {
        this.uspsShippingAPI = uspsShippingAPI;
    }

    @Override
    public String getRateRequestElement() {
        return this.rateRequestElement;
    }

    @Override
    public void setRateRequestElement(String rateRequestElement) {
        this.rateRequestElement = rateRequestElement;
    }

    @Override
    public USPSRequestValidator getUspsRequestValidator() {
        return this.uspsRequestValidator;
    }

    @Override
    public void setUspsRequestValidator(USPSRequestValidator uspsRequestValidator) {
        this.uspsRequestValidator = uspsRequestValidator;
    }

    @Override
    public USPSRequestBuilder getUspsRequestBuilder() {
        return this.uspsRequestBuilder;
    }

    @Override
    public void setUspsRequestBuilder(USPSRequestBuilder uspsRequestBuilder) {
        this.uspsRequestBuilder = uspsRequestBuilder;
    }

    public USPSResponseBuilder getUspsResponseBuilder() {
        return this.uspsResponseBuilder;
    }

    public void setUspsResponseBuilder(USPSResponseBuilder uspsResponseBuilder) {
        this.uspsResponseBuilder = uspsResponseBuilder;
    }
}

