/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.message.v3;

import java.math.BigDecimal;
import java.util.Calendar;
import org.broadleafcommerce.profile.util.DimensionUnitOfMeasureType;
import org.broadleafcommerce.profile.util.UnitOfMeasureUtil;
import org.broadleafcommerce.profile.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.profile.vendor.service.exception.ShippingPriceException;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSVersionedRequestValidator;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerShapeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSContainerSizeType;
import org.broadleafcommerce.vendor.usps.service.type.USPSFirstClassType;
import org.broadleafcommerce.vendor.usps.service.type.USPSServiceType;
import org.broadleafcommerce.vendor.usps.service.type.USPSShippingPriceErrorCode;

public class USPSRequestValidator
implements USPSVersionedRequestValidator {
    @Override
    public void validateService(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        USPSServiceType service = itemRequest.getService();
        if (service.equals(USPSServiceType.FIRSTCLASS) && itemRequest.getFirstClassType() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.FIRSTCLASSNOTSPECIFIED.getType(), USPSShippingPriceErrorCode.FIRSTCLASSNOTSPECIFIED.getMessage());
        }
    }

    @Override
    public void validateWeight(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        USPSServiceType service = itemRequest.getService();
        if (service.equals(USPSServiceType.FIRSTCLASS) && (itemRequest.getFirstClassType().equals(USPSFirstClassType.LETTER) ? UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > UnitOfMeasureUtil.convertOuncesToPounds((BigDecimal)BigDecimal.valueOf(3.5)).doubleValue() : UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > UnitOfMeasureUtil.convertOuncesToPounds((BigDecimal)BigDecimal.valueOf(13L)).doubleValue())) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.OVERWEIGHT.getType(), USPSShippingPriceErrorCode.OVERWEIGHT.getMessage());
        }
        if (service.equals(USPSServiceType.BPM) && UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > 15.0) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.OVERWEIGHT.getType(), USPSShippingPriceErrorCode.OVERWEIGHT.getMessage());
        }
        if (UnitOfMeasureUtil.findPounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue() > 70.0) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.OVERWEIGHT.getType(), USPSShippingPriceErrorCode.OVERWEIGHT.getMessage());
        }
    }

    @Override
    public void validateSize(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if ((itemRequest.getService().equals(USPSServiceType.ALL) || itemRequest.getService().equals(USPSServiceType.ONLINE) || itemRequest.getService().equals(USPSServiceType.PARCEL) || itemRequest.getService().equals(USPSServiceType.BPM) || itemRequest.getService().equals(USPSServiceType.MEDIA) || itemRequest.getService().equals(USPSServiceType.LIBRARY)) && itemRequest.getContainerSize() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.SIZENOTSPECIFIED.getType(), USPSShippingPriceErrorCode.SIZENOTSPECIFIED.getMessage());
        }
    }

    @Override
    public void validateContainer(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
    }

    @Override
    public void validateMachinable(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if ((itemRequest.getService().equals(USPSServiceType.ALL) || itemRequest.getService().equals(USPSServiceType.ONLINE) || itemRequest.getService().equals(USPSServiceType.PARCEL) || itemRequest.getService().equals(USPSServiceType.FIRSTCLASS) && (itemRequest.getFirstClassType().equals(USPSFirstClassType.LETTER) || itemRequest.getFirstClassType().equals(USPSFirstClassType.FLAT))) && itemRequest.isMachineSortable() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.MACHINABLESPECIFIED.getType(), USPSShippingPriceErrorCode.MACHINABLESPECIFIED.getMessage());
        }
    }

    @Override
    public void validateDimensions(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if ((itemRequest.getService().equals(USPSServiceType.ALL) || itemRequest.getService().equals(USPSServiceType.ONLINE) || itemRequest.getService().equals(USPSServiceType.PRIORITY) || itemRequest.getService().equals(USPSServiceType.PRIORITYCOMMERCIAL)) && itemRequest.getContainerSize().equals((Object)USPSContainerSizeType.LARGE) && itemRequest.getContainerShape() != null && (itemRequest.getContainerShape().equals((Object)USPSContainerShapeType.RECTANGULAR) || itemRequest.getContainerShape().equals((Object)USPSContainerShapeType.NONRECTANGULAR))) {
            if (itemRequest.getDepth() == null || itemRequest.getHeight() == null || itemRequest.getWidth() == null) {
                throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.DIMENSIONSNOTSPECIFIED.getType(), USPSShippingPriceErrorCode.DIMENSIONSNOTSPECIFIED.getMessage());
            }
            if (itemRequest.getDimensionUnitOfMeasureType() == null) {
                throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.UNITTYPENOTSPECIFIED.getType(), USPSShippingPriceErrorCode.UNITTYPENOTSPECIFIED.getMessage());
            }
            if (!(itemRequest.getDimensionUnitOfMeasureType().equals((Object)DimensionUnitOfMeasureType.METERS) || itemRequest.getDimensionUnitOfMeasureType().equals((Object)DimensionUnitOfMeasureType.FEET) || itemRequest.getDimensionUnitOfMeasureType().equals((Object)DimensionUnitOfMeasureType.CENTIMETERS) || itemRequest.getDimensionUnitOfMeasureType().equals((Object)DimensionUnitOfMeasureType.INCHES))) {
                throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.UNITTYPENOTSUPPORTED.getType(), USPSShippingPriceErrorCode.UNITTYPENOTSUPPORTED.getMessage());
            }
        }
    }

    @Override
    public void validateGirth(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if ((itemRequest.getService().equals(USPSServiceType.ALL) || itemRequest.getService().equals(USPSServiceType.ONLINE) || itemRequest.getService().equals(USPSServiceType.PRIORITY) || itemRequest.getService().equals(USPSServiceType.PRIORITYCOMMERCIAL)) && itemRequest.getContainerSize().equals((Object)USPSContainerSizeType.LARGE) && itemRequest.getContainerShape() != null && itemRequest.getContainerShape().equals((Object)USPSContainerShapeType.NONRECTANGULAR) && itemRequest.getGirth() == null) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.GIRTHNOTSPECIFIED.getType(), USPSShippingPriceErrorCode.GIRTHNOTSPECIFIED.getMessage());
        }
    }

    @Override
    public void validateShipDate(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        Calendar maxAdvance = Calendar.getInstance();
        maxAdvance.add(5, 3);
        if (itemRequest.getShipDate() != null && itemRequest.getShipDate().getTime() > maxAdvance.getTime().getTime()) {
            throw org.broadleafcommerce.vendor.usps.service.message.USPSRequestValidator.buildException(USPSShippingPriceErrorCode.SHIPDATETOOFAR.getType(), USPSShippingPriceErrorCode.SHIPDATETOOFAR.getMessage());
        }
    }

    @Override
    public void validateOther(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
    }
}

