/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service.module;

import java.util.List;
import java.util.Stack;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.vendor.service.exception.ShippingPriceException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.pricing.service.module.ShippingModule;
import org.broadleafcommerce.pricing.service.module.USPSSingleItemPerPackageShippingCalculationModule;
import org.broadleafcommerce.vendor.usps.service.USPSShippingCalculationService;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemResponse;
import org.broadleafcommerce.vendor.usps.service.message.USPSPostage;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceResponse;
import org.broadleafcommerce.vendor.usps.service.type.USPSServiceResponseType;

public abstract class USPSShippingCalculationModule
implements ShippingModule {
    private static final Log LOG = LogFactory.getLog(USPSSingleItemPerPackageShippingCalculationModule.class);
    protected String name = "USPSShippingCalculationModule";
    protected String originationPostalCode;
    protected Boolean isDefaultModule = false;
    @Resource
    protected USPSShippingCalculationService shippingCalculationService;

    public FulfillmentGroup calculateShippingForFulfillmentGroup(FulfillmentGroup fulfillmentGroup) throws ShippingPriceException {
        if (!this.isValidModuleForService(fulfillmentGroup.getService()).booleanValue() && !this.isDefaultModule().booleanValue()) {
            LOG.info((Object)("fulfillment group (" + fulfillmentGroup.getId() + ") with a service type of (" + fulfillmentGroup.getService() + ") is not valid for this module service type (" + this.getServiceName() + ")"));
            return fulfillmentGroup;
        }
        if (fulfillmentGroup.getFulfillmentGroupItems().size() == 0) {
            LOG.warn((Object)("fulfillment group (" + fulfillmentGroup.getId() + ") does not contain any fulfillment group items. Unable to price USPS shipping"));
            fulfillmentGroup.setShippingPrice(new Money(0.0));
            fulfillmentGroup.setSaleShippingPrice(new Money(0.0));
            fulfillmentGroup.setRetailShippingPrice(new Money(0.0));
            return fulfillmentGroup;
        }
        List<USPSContainerItemRequest> requestItems = this.createPackages(fulfillmentGroup);
        USPSShippingPriceRequest request = new USPSShippingPriceRequest();
        request.getContainerItems().addAll(requestItems);
        USPSShippingPriceResponse response = this.shippingCalculationService.process(request);
        Stack<USPSContainerItemResponse> itemResponses = response.getResponses();
        USPSServiceResponseType responseType = USPSServiceResponseType.getInstanceByName(fulfillmentGroup.getMethod());
        if (responseType == null) {
            throw new ShippingPriceException("No USPSServiceResponseType found for the shipping method (" + fulfillmentGroup.getMethod() + ") and service type (" + this.getServiceName() + ")");
        }
        Money shippingPrice = new Money(0.0);
        for (USPSContainerItemResponse itemResponse : itemResponses) {
            USPSPostage postage = this.deducePostage(responseType, requestItems, itemResponse);
            if (postage == null) {
                throw new ShippingPriceException("No postage found in the USPS response for the USPSServiceResponseType (" + responseType.getDescription() + ")");
            }
            shippingPrice = shippingPrice.add(postage.getRate());
        }
        fulfillmentGroup.setShippingPrice(shippingPrice);
        fulfillmentGroup.setSaleShippingPrice(fulfillmentGroup.getShippingPrice());
        fulfillmentGroup.setRetailShippingPrice(fulfillmentGroup.getSaleShippingPrice());
        return fulfillmentGroup;
    }

    protected USPSPostage deducePostage(USPSServiceResponseType responseType, List<USPSContainerItemRequest> requestItems, USPSContainerItemResponse itemResponse) {
        USPSPostage postage = itemResponse.getPostage().get(responseType);
        if (postage == null) {
            USPSContainerItemRequest itemRequest = this.findRequestByPackageId(itemResponse.getPackageId(), requestItems);
            if (itemRequest != null) {
                String shape = itemRequest.getContainerShape().getType().replaceAll(" ", "");
                String moreSpecificResponseType = responseType.getName() + shape;
                USPSServiceResponseType nextResponseType = USPSServiceResponseType.getInstanceByName(moreSpecificResponseType);
                if (nextResponseType != null) {
                    postage = itemResponse.getPostage().get(nextResponseType);
                }
            }
            if (postage == null && itemResponse.getPostage().size() == 1) {
                postage = itemResponse.getPostage().values().iterator().next();
            }
        }
        return postage;
    }

    protected USPSContainerItemRequest findRequestByPackageId(String packageId, List<USPSContainerItemRequest> requestItems) {
        for (USPSContainerItemRequest itemRequest : requestItems) {
            if (!itemRequest.getPackageId().equals(packageId)) continue;
            return itemRequest;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract List<USPSContainerItemRequest> createPackages(FulfillmentGroup var1) throws ShippingPriceException;

    public Boolean isValidModuleForService(String serviceName) {
        return this.getServiceName().equals(serviceName);
    }

    public String getOriginationPostalCode() {
        return this.originationPostalCode;
    }

    public void setOriginationPostalCode(String originationPostalCode) {
        this.originationPostalCode = originationPostalCode;
    }

    public Boolean isDefaultModule() {
        return this.isDefaultModule;
    }

    public void setDefaultModule(Boolean isDefaultModule) {
        this.isDefaultModule = isDefaultModule;
    }
}

