/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.message;

import org.broadleafcommerce.common.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.common.vendor.service.exception.ShippingPriceException;
import org.broadleafcommerce.common.vendor.service.message.ShippingPriceResponse;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceResponse;
import org.broadleafcommerce.vendor.usps.service.message.USPSVersionedRequestValidator;
import org.broadleafcommerce.vendor.usps.service.type.USPSShippingPriceErrorCode;

public class USPSRequestValidator {
    private final USPSVersionedRequestValidator versionedValidator;

    public USPSRequestValidator(USPSVersionedRequestValidator versionedValidator) {
        this.versionedValidator = versionedValidator;
    }

    public void validateRequest(USPSShippingPriceRequest request) throws ShippingPriceException {
        this.validatePackageQuantity(request);
        for (USPSContainerItemRequest itemRequest : request.getContainerItems()) {
            this.validateService(itemRequest);
            this.validateWeight(itemRequest);
            this.validateZip(itemRequest);
            this.validateSize(itemRequest);
            this.validateContainer(itemRequest);
            this.validateMachinable(itemRequest);
            this.validateDimensions(itemRequest);
            this.validateGirth(itemRequest);
            this.validateShipDate(itemRequest);
            this.validateOther(itemRequest);
        }
    }

    protected void validateOther(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if (itemRequest.getPackageId() == null) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.PACKAGEIDNOTSPECIFIED.getType(), USPSShippingPriceErrorCode.PACKAGEIDNOTSPECIFIED.getMessage());
        }
        this.versionedValidator.validateOther(itemRequest);
    }

    protected void validateShipDate(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        this.versionedValidator.validateShipDate(itemRequest);
    }

    protected void validateGirth(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        this.versionedValidator.validateGirth(itemRequest);
    }

    protected void validateDimensions(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        this.versionedValidator.validateDimensions(itemRequest);
    }

    protected void validateMachinable(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        this.versionedValidator.validateMachinable(itemRequest);
    }

    protected void validateSize(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        this.versionedValidator.validateSize(itemRequest);
    }

    protected void validateContainer(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        this.versionedValidator.validateContainer(itemRequest);
    }

    protected void validateZip(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if (itemRequest.getZipDestination() == null || itemRequest.getZipOrigination() == null) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.ZIPNOTSPECIFIED.getType(), USPSShippingPriceErrorCode.ZIPNOTSPECIFIED.getMessage());
        }
        if (itemRequest.getZipDestination().length() != 5 || itemRequest.getZipOrigination().length() != 5) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.ZIPLENGTH.getType(), USPSShippingPriceErrorCode.ZIPLENGTH.getMessage());
        }
    }

    protected void validateService(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if (itemRequest.getService() == null) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.SERVICENOTSPECIFIED.getType(), USPSShippingPriceErrorCode.SERVICENOTSPECIFIED.getMessage());
        }
        this.versionedValidator.validateService(itemRequest);
    }

    protected void validateWeight(USPSContainerItemRequest itemRequest) throws ShippingPriceException {
        if (itemRequest.getWeight() == null) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.WEIGHTNOTSPECIFIED.getType(), USPSShippingPriceErrorCode.WEIGHTNOTSPECIFIED.getMessage());
        }
        if (itemRequest.getWeightUnitOfMeasureType() == null) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.UNITTYPENOTSPECIFIED.getType(), USPSShippingPriceErrorCode.UNITTYPENOTSPECIFIED.getMessage());
        }
        if (!itemRequest.getWeightUnitOfMeasureType().equals((Object)WeightUnitOfMeasureType.KILOGRAMS) && !itemRequest.getWeightUnitOfMeasureType().equals((Object)WeightUnitOfMeasureType.POUNDS)) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.UNITTYPENOTSUPPORTED.getType(), USPSShippingPriceErrorCode.UNITTYPENOTSUPPORTED.getMessage());
        }
        this.versionedValidator.validateWeight(itemRequest);
    }

    protected void validatePackageQuantity(USPSShippingPriceRequest request) throws ShippingPriceException {
        if (request.getContainerItems().size() > 25) {
            throw USPSRequestValidator.buildException(USPSShippingPriceErrorCode.TOOMANYCONTAINERITEMS.getType(), USPSShippingPriceErrorCode.TOOMANYCONTAINERITEMS.getMessage());
        }
    }

    public static ShippingPriceException buildException(String errorCode, String errorText) {
        USPSShippingPriceResponse response = new USPSShippingPriceResponse();
        response.setErrorDetected(true);
        response.setErrorCode(errorCode);
        response.setErrorText(errorText);
        ShippingPriceException e = new ShippingPriceException();
        e.setShippingPriceResponse((ShippingPriceResponse)response);
        return e;
    }
}

