/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class USPSShippingPriceErrorCode
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, USPSShippingPriceErrorCode> TYPES = new HashMap<String, USPSShippingPriceErrorCode>();
    public static final USPSShippingPriceErrorCode TOOMANYCONTAINERITEMS = new USPSShippingPriceErrorCode("bl_items", "Too Many Container Items", "No more than 25 packages may be included in the request.");
    public static final USPSShippingPriceErrorCode WEIGHTNOTSPECIFIED = new USPSShippingPriceErrorCode("bl_wns", "Weight Not Specified", "The package weight must be specified for this request.");
    public static final USPSShippingPriceErrorCode OVERWEIGHT = new USPSShippingPriceErrorCode("bl_ow", "Over Weight", "Package exceeds weight limit specified by carrier.");
    public static final USPSShippingPriceErrorCode SHAPENOTSPECIFIED = new USPSShippingPriceErrorCode("bl_sns", "Shape Not Specified", "The package shape must be specified for this request.");
    public static final USPSShippingPriceErrorCode SHAPENOTSUPPORTED = new USPSShippingPriceErrorCode("bl_shapesupport", "Shape Not Supported", "The package shape type specified is not supported.");
    public static final USPSShippingPriceErrorCode DIMENSIONSNOTSPECIFIED = new USPSShippingPriceErrorCode("bl_dns", "Dimensions Not Specified", "The package dimensions must be specified for this request.");
    public static final USPSShippingPriceErrorCode GIRTHNOTSPECIFIED = new USPSShippingPriceErrorCode("bl_dns", "Girth Not Specified", "The package girth must be specified for this request.");
    public static final USPSShippingPriceErrorCode PACKAGEIDNOTSPECIFIED = new USPSShippingPriceErrorCode("bl_pkid", "Package ID Not Specified", "The package id must be specified.");
    public static final USPSShippingPriceErrorCode ZIPNOTSPECIFIED = new USPSShippingPriceErrorCode("bl_zip", "Zip Not Specified", "The origin and destination zip codes must be specified.");
    public static final USPSShippingPriceErrorCode ZIPLENGTH = new USPSShippingPriceErrorCode("bl_ziplength", "Zip Length", "The origin and destination zip codes must be 5 digits in length.");
    public static final USPSShippingPriceErrorCode UNITTYPENOTSUPPORTED = new USPSShippingPriceErrorCode("bl_unit", "Unit Type Not Supported", "The unit of measure type specified is not supported.");
    public static final USPSShippingPriceErrorCode UNITTYPENOTSPECIFIED = new USPSShippingPriceErrorCode("bl_type", "Unit Type Not Specified", "The dimension and weight unit of measure types must be specified for this request.");
    public static final USPSShippingPriceErrorCode SHIPDATETOOFAR = new USPSShippingPriceErrorCode("bl_shipdate", "Ship Date Too Far In Advance", "The ship date may only be 0 to 3 days in advance.");
    public static final USPSShippingPriceErrorCode SERVICENOTSPECIFIED = new USPSShippingPriceErrorCode("bl_service", "Service Not Specified", "The service must be specified for this request.");
    public static final USPSShippingPriceErrorCode SERVICENOTSUPPORTED = new USPSShippingPriceErrorCode("bl_servicesupported", "Service Not Supported", "The service type specified is not compatible with this version of the USPS api.");
    public static final USPSShippingPriceErrorCode FIRSTCLASSNOTSPECIFIED = new USPSShippingPriceErrorCode("bl_firstclass", "First Class Not Specified", "The first class container type must be specified for this request.");
    public static final USPSShippingPriceErrorCode SIZENOTSPECIFIED = new USPSShippingPriceErrorCode("bl_size", "Size Not Specified", "The container size type must be specified for this request.");
    public static final USPSShippingPriceErrorCode SIZENOTSUPPORTED = new USPSShippingPriceErrorCode("bl_sizesupported", "Size Not Supported", "The container size type specified is not supported.");
    public static final USPSShippingPriceErrorCode MACHINABLESPECIFIED = new USPSShippingPriceErrorCode("bl_machinable", "Machine Sortable Not Specified", "The machine sortable value must be specified for this request.");
    private String type;
    private String message;
    private String friendlyType;

    public static USPSShippingPriceErrorCode getInstance(String type) {
        return TYPES.get(type);
    }

    public USPSShippingPriceErrorCode() {
    }

    public USPSShippingPriceErrorCode(String type, String friendlyType, String message) {
        this.friendlyType = friendlyType;
        this.setType(type);
        this.setMessage(message);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public String getMessage() {
        return this.message;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        USPSShippingPriceErrorCode other = (USPSShippingPriceErrorCode)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

