/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog;

import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.testng.annotations.DataProvider;

public class ProductDataProvider {
    @DataProvider(name="basicProduct")
    public static Object[][] provideBasicProduct() {
        ProductImpl ci = new ProductImpl();
        ci.setName("setOfAggieDominoes");
        ci.setDescription("a fine set of bones for 42");
        return new Object[][]{{ci}};
    }

    @DataProvider(name="setupProducts")
    public static Object[][] createProducts() {
        Product p1 = ProductDataProvider.getProduct(null);
        Product p2 = ProductDataProvider.getProduct(null);
        Product p3 = ProductDataProvider.getProduct(null);
        Product p4 = ProductDataProvider.getProduct(null);
        Product p5 = ProductDataProvider.getProduct(null);
        Product p6 = ProductDataProvider.getProduct(null);
        Product p7 = ProductDataProvider.getProduct(null);
        Object[][] objs = new Object[7][1];
        objs[0] = new Object[]{p1};
        objs[1] = new Object[]{p2};
        objs[2] = new Object[]{p3};
        objs[3] = new Object[]{p4};
        objs[4] = new Object[]{p5};
        objs[5] = new Object[]{p6};
        objs[6] = new Object[]{p7};
        return objs;
    }

    @DataProvider(name="basicCrossSaleValue")
    public static Object[][] provideBasicCrossSale() {
        Product p1 = ProductDataProvider.getProduct(1L);
        Product p2 = ProductDataProvider.getProduct(2L);
        Product rel1 = ProductDataProvider.getProduct(3L);
        Product rel2 = ProductDataProvider.getProduct(4L);
        Product rel3 = ProductDataProvider.getProduct(5L);
        Product rel4 = ProductDataProvider.getProduct(6L);
        Product rel5 = ProductDataProvider.getProduct(7L);
        ArrayList<RelatedProduct> p1UpSales = new ArrayList<RelatedProduct>();
        ProductDataProvider.getRelatedCrossProduct(p1, rel1, p1UpSales);
        ProductDataProvider.getRelatedCrossProduct(p1, rel2, p1UpSales);
        ProductDataProvider.getRelatedCrossProduct(p1, rel3, p1UpSales);
        p1.setCrossSaleProducts(p1UpSales);
        ArrayList<RelatedProduct> p2UpSales = new ArrayList<RelatedProduct>();
        ProductDataProvider.getRelatedCrossProduct(p2, rel4, p2UpSales);
        ProductDataProvider.getRelatedCrossProduct(p2, rel5, p2UpSales);
        p2.setCrossSaleProducts(p2UpSales);
        Object[][] objs = new Object[2][1];
        objs[0] = new Object[]{p1};
        objs[1] = new Object[]{p2};
        return objs;
    }

    @DataProvider(name="basicUpSaleValue")
    public static Object[][] provideBasicUpSale() {
        Product p1 = ProductDataProvider.getProduct(1L);
        Product p2 = ProductDataProvider.getProduct(2L);
        Product rel1 = ProductDataProvider.getProduct(3L);
        Product rel2 = ProductDataProvider.getProduct(4L);
        Product rel3 = ProductDataProvider.getProduct(5L);
        Product rel4 = ProductDataProvider.getProduct(6L);
        Product rel5 = ProductDataProvider.getProduct(7L);
        ArrayList<RelatedProduct> p1UpSales = new ArrayList<RelatedProduct>();
        ProductDataProvider.getRelatedUpSaleProduct(p1, rel1, p1UpSales);
        ProductDataProvider.getRelatedUpSaleProduct(p1, rel2, p1UpSales);
        ProductDataProvider.getRelatedUpSaleProduct(p1, rel3, p1UpSales);
        p1.setUpSaleProducts(p1UpSales);
        ArrayList<RelatedProduct> p2UpSales = new ArrayList<RelatedProduct>();
        ProductDataProvider.getRelatedUpSaleProduct(p2, rel4, p2UpSales);
        ProductDataProvider.getRelatedUpSaleProduct(p2, rel5, p2UpSales);
        p2.setUpSaleProducts(p2UpSales);
        Object[][] objs = new Object[2][1];
        objs[0] = new Object[]{p1};
        objs[1] = new Object[]{p2};
        return objs;
    }

    private static RelatedProduct getRelatedUpSaleProduct(Product prod, Product prodToRelate, List<RelatedProduct> upSales) {
        UpSaleProductImpl rp1 = new UpSaleProductImpl();
        rp1.setProduct(prod);
        rp1.setPromotionMessage("brand new coffee");
        rp1.setRelatedProduct(prodToRelate);
        upSales.add((RelatedProduct)rp1);
        return rp1;
    }

    private static RelatedProduct getRelatedCrossProduct(Product prod, Product prodToRelate, List<RelatedProduct> upSales) {
        CrossSaleProductImpl rp1 = new CrossSaleProductImpl();
        rp1.setProduct(prod);
        rp1.setPromotionMessage("brand new coffee");
        rp1.setRelatedProduct(prodToRelate);
        upSales.add((RelatedProduct)rp1);
        return rp1;
    }

    private static Product getProduct(Long id) {
        if (id == null) {
            ProductImpl product = new ProductImpl();
            product.setName("productNameTest");
            return product;
        }
        ProductImpl p = new ProductImpl();
        p.setId(id);
        p.setName(id.toString());
        return p;
    }
}

