/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.layout;

import java.util.LinkedList;
import java.util.List;
import org.broadleafcommerce.core.web.PaginationCommandObject;
import org.broadleafcommerce.test.BaseTest;
import org.testng.annotations.Test;

public class PaginationCommandObjectTest
extends BaseTest {
    @Test(groups={"paginationObject"})
    public void testIndices() {
        PaginationCommandObject pco = new PaginationCommandObject();
        pco.setPageNumber(1);
        pco.setPageSize(25);
        pco.setListSize(60);
        assert (pco.getStartIndex() == 25);
        assert (pco.getEndIndex() == 50);
        pco.setPageNumber(2);
        assert (pco.getStartIndex() == 50);
        assert (pco.getEndIndex() == 60);
    }

    @Test(groups={"paginationObject"})
    public void testDisplayList() {
        PaginationCommandObject pco = new PaginationCommandObject();
        LinkedList<Integer> tmp = new LinkedList<Integer>();
        for (int i = 25; i < 50; ++i) {
            tmp.add(new Integer(i));
        }
        pco.setDisplayList(tmp);
        pco.setPageSize(25);
        pco.setPageNumber(1);
        Integer index3 = (Integer)pco.getDisplayList().get(3);
        Integer index13 = (Integer)pco.getDisplayList().get(13);
        assert (index3 == 28);
        assert (index13 == 38);
    }

    @Test(groups={"paginationObject"})
    public void testFullList() {
        PaginationCommandObject pco = new PaginationCommandObject();
        LinkedList<Integer> tmp = new LinkedList<Integer>();
        for (int i = 0; i < 60; ++i) {
            tmp.add(new Integer(i));
        }
        pco.setFullList(tmp);
        pco.setPageSize(25);
        pco.setPageNumber(1);
        List dl = pco.getDisplayList();
        Integer index3 = (Integer)dl.get(3);
        Integer index13 = (Integer)dl.get(13);
        assert (dl.size() == 25);
        assert (index3 == 28);
        assert (index13 == 38);
        pco.setPageNumber(2);
        dl = pco.getDisplayList();
        index3 = (Integer)dl.get(3);
        assert (dl.size() == 10);
        assert (index3 == 53);
    }
}

