/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.FulfillmentGroupDataProvider;
import org.broadleafcommerce.core.order.OrderItemDataProvider;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.dao.CustomerAddressDao;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class FulfillmentGroupItemDaoTest
extends BaseTest {
    private FulfillmentGroup fulfillmentGroup;
    private Order salesOrder;
    private Long fulfillmentGroupItemId;
    @Resource
    private FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource
    private CustomerService customerService;
    @Resource
    private OrderDao orderDao;
    @Resource
    private SkuDao skuDao;
    @Resource
    private OrderItemDao orderItemDao;
    @Resource
    private CartService cartService;
    @Resource
    private CustomerAddressDao customerAddressDao;
    @Resource
    private FulfillmentGroupDao fulfillmentGroupDao;
    @Resource
    private FulfillmentGroupService fulfillmentGroupService;

    @Test(groups={"createItemFulfillmentGroup"}, dataProvider="basicFulfillmentGroup", dataProviderClass=FulfillmentGroupDataProvider.class, dependsOnGroups={"createOrder", "createCustomerAddress"})
    @Rollback(value=false)
    @Transactional
    public void createDefaultFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Address address = ((CustomerAddress)this.customerAddressDao.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        this.salesOrder = this.orderDao.createNewCartForCustomer(customer);
        FulfillmentGroup newFG = this.fulfillmentGroupDao.createDefault();
        newFG.setAddress(address);
        newFG.setRetailShippingPrice(fulfillmentGroup.getRetailShippingPrice());
        newFG.setMethod(fulfillmentGroup.getMethod());
        newFG.setService(fulfillmentGroup.getService());
        newFG.setOrder(this.salesOrder);
        newFG.setReferenceNumber(fulfillmentGroup.getReferenceNumber());
        assert (newFG.getId() == null);
        this.fulfillmentGroup = this.fulfillmentGroupService.save(newFG);
        assert (this.fulfillmentGroup.getId() != null);
    }

    @Test(groups={"createFulfillmentGroupItem"}, dataProvider="basicDiscreteOrderItem", dataProviderClass=OrderItemDataProvider.class, dependsOnGroups={"createOrder", "createSku", "createItemFulfillmentGroup"})
    @Rollback(value=false)
    @Transactional
    public void createFulfillmentGroupItem(DiscreteOrderItem orderItem) throws PricingException {
        Sku si = this.skuDao.readFirstSku();
        orderItem.setSku(si);
        orderItem = (DiscreteOrderItem)this.orderItemDao.save((OrderItem)orderItem);
        orderItem.setOrder(this.salesOrder);
        this.salesOrder.addOrderItem((OrderItem)orderItem);
        this.orderDao.save(this.salesOrder);
        this.fulfillmentGroup = this.cartService.addItemToFulfillmentGroup((OrderItem)orderItem, this.fulfillmentGroup, orderItem.getQuantity());
        FulfillmentGroupItem fgi = (FulfillmentGroupItem)this.fulfillmentGroup.getFulfillmentGroupItems().get(this.fulfillmentGroup.getFulfillmentGroupItems().size() - 1);
        assert (fgi.getId() != null);
        this.fulfillmentGroupItemId = fgi.getId();
    }

    @Test(groups={"readFulfillmentGroupItemsForFulfillmentGroup"}, dependsOnGroups={"createFulfillmentGroupItem"})
    @Transactional
    public void readFulfillmentGroupItemsForFulfillmentGroup() {
        List fgis = this.fulfillmentGroupItemDao.readFulfillmentGroupItemsForFulfillmentGroup(this.fulfillmentGroup);
        assert (fgis != null);
        assert (fgis.size() > 0);
    }

    @Test(groups={"readFulfillmentGroupItemsById"}, dependsOnGroups={"createFulfillmentGroupItem"})
    @Transactional
    public void readFulfillmentGroupItemsById() {
        FulfillmentGroupItem fgi = this.fulfillmentGroupItemDao.readFulfillmentGroupItemById(this.fulfillmentGroupItemId);
        assert (fgi != null);
        assert (fgi.getId() != null);
    }
}

