/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.content.dao;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.content.ContentDaoDataProvider;
import org.broadleafcommerce.core.content.dao.ContentDao;
import org.broadleafcommerce.core.content.dao.ContentDetailsDao;
import org.broadleafcommerce.core.content.domain.Content;
import org.broadleafcommerce.core.content.domain.ContentDetails;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class ContentDaoTest
extends BaseTest {
    @Resource
    private ContentDao contentDao;
    @Resource
    private ContentDetailsDao contentDetailsDao;
    private Integer contentId;

    @Test(groups={"testSaveContent"}, dataProvider="basicContent", dataProviderClass=ContentDaoDataProvider.class)
    @Rollback(value=false)
    @Transactional
    public void testSaveContent(Content content) {
        assert (content.getId() == null);
        Content newContent = this.contentDao.saveContent(content);
        assert (newContent.getId() != null);
        assert (newContent.getActiveEndDate() == null && content.getActiveEndDate() == null || newContent.getActiveEndDate().equals(content.getActiveEndDate()));
        assert (newContent.getActiveStartDate() == null && content.getActiveStartDate() == null || newContent.getActiveStartDate().equals(content.getActiveStartDate()));
        assert (newContent.getTitle() == null && content.getTitle() == null || newContent.getTitle().equals(content.getTitle()));
        assert (newContent.getDisplayRule() == null && content.getDisplayRule() == null || newContent.getDisplayRule().equals(content.getDisplayRule()));
        assert (newContent.getSandbox() == null && content.getSandbox() == null || newContent.getSandbox().equals(content.getSandbox()));
        assert (newContent.getContentType() == null && content.getContentType() == null || newContent.getContentType().equals(content.getContentType()));
        this.contentId = newContent.getId();
    }

    @Test(groups={"testReadContentById"}, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadContentById() {
        Content content = this.contentDao.readContentById(this.contentId);
        assert (content != null);
        assert (content.getId() == this.contentId);
    }

    @Test(groups={"testReadContentByVersionSandboxFile"}, dataProvider="basicContent", dataProviderClass=ContentDaoDataProvider.class, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadContentByVersionSandboxFile(Content content) {
        List newContents = this.contentDao.readContentSpecified(content.getSandbox(), content.getContentType(), SystemTime.asDate());
        assert (newContents != null && !newContents.isEmpty());
        Content newContent = (Content)newContents.get(0);
        assert (newContent != null);
        assert (newContent.getId() != null);
        assert (newContent.getId().equals(this.contentId));
    }

    @Test(groups={"testUpdateContent"}, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testUpdateContent() {
        String title = "/new/file/path";
        Content content = this.contentDao.readContentById(this.contentId);
        String oldtitle = content.getTitle();
        content.setTitle(title);
        this.contentDao.saveContent(content);
        Content newContent = this.contentDao.readContentById(this.contentId);
        assert (newContent != null);
        assert (newContent.getId().equals(content.getId()));
        assert (!newContent.getTitle().equals(oldtitle));
        assert (newContent.getTitle().equals(title));
    }

    @Test(groups={"testRreadContentByIdsAndSandbox"}, dataProvider="basicContent", dataProviderClass=ContentDaoDataProvider.class, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadContentByIdsAndSandbox(Content content) {
        ArrayList<Integer> contentIds = new ArrayList<Integer>();
        contentIds.add(this.contentId);
        List contentList = this.contentDao.readContentByIdsAndSandbox(contentIds, content.getSandbox());
        assert (contentList != null && !contentList.isEmpty());
    }

    @Test(groups={"testReadContentBySandbox"}, dataProvider="basicContent", dataProviderClass=ContentDaoDataProvider.class, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadContentBySandbox(Content content) {
        List newContents = this.contentDao.readContentBySandbox(content.getSandbox());
        assert (newContents != null && !newContents.isEmpty());
        Content newContent = (Content)newContents.get(0);
        assert (newContent != null);
        assert (newContent.getId() != null);
        assert (newContent.getId().equals(this.contentId));
    }

    @Test(groups={"testReadContentBySandbox"}, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadContentAwaitingApproval() {
        List newContents = this.contentDao.readContentAwaitingApproval();
        assert (newContents != null && !newContents.isEmpty());
        Content newContent = (Content)newContents.get(0);
        assert (newContent != null);
        assert (newContent.getApprovedBy() == null);
        assert (newContent.getApprovedDate() == null);
    }

    @Test(groups={"testReadContentBySandboxAndType"}, dataProvider="basicContent", dataProviderClass=ContentDaoDataProvider.class, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadContentBySandboxAndType(Content content) {
        List newContents = this.contentDao.readContentBySandboxAndType(content.getSandbox(), content.getContentType());
        assert (newContents != null && !newContents.isEmpty());
        Content newContent = (Content)newContents.get(0);
        assert (newContent != null);
        assert (newContent.getSandbox().equals(content.getSandbox()));
        assert (newContent.getContentType().equals(content.getContentType()));
    }

    @Test(groups={"testDeleteContent"}, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testDeleteContent() {
        Content content = this.contentDao.readContentById(this.contentId);
        this.contentDao.delete(content);
        Content newContent = this.contentDao.readContentById(this.contentId);
        assert (newContent == null);
        ContentDetails contentDetails = this.contentDetailsDao.readContentDetailsById(this.contentId);
        assert (contentDetails == null);
    }

    @Test(groups={"testDeleteContent"}, dependsOnGroups={"testSaveContent"})
    @Transactional
    public void testReadStagedContent() {
        Content content = this.contentDao.readContentById(this.contentId);
        content.setSandbox(null);
        this.contentDao.saveContent(content);
        List newContents = this.contentDao.readStagedContent();
        assert (newContents != null && !newContents.isEmpty());
    }
}

