/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.test.CommonSetupBaseTest;

public class OrderBaseTest
extends CommonSetupBaseTest {
    @Resource
    protected CartService cartService;
    private int bundleCount = 0;

    protected Customer createNamedCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer.setUsername(String.valueOf(customer.getId()));
        return customer;
    }

    public Order setUpNamedOrder() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Sku newSku = this.addTestSku("Small Cube Box", "Cube Box", "Boxes");
        Order order = this.orderService.createNamedOrderForCustomer("Boxes Named Order", customer);
        Product newProduct = (Product)newSku.getAllParentProducts().get(0);
        Category newCategory = newProduct.getDefaultCategory();
        this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        return order;
    }

    public Order setUpAnonymousCartWithInactiveSku() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        Sku newSku = this.addTestSku("Small Plastic Crate", "Plastic Crate", "Crates");
        Sku newInactiveSku = this.addTestSku("Small Red Plastic Crate", "Plastic Crate", "Crates", false);
        Product newProduct = (Product)newSku.getAllParentProducts().get(0);
        Category newCategory = newProduct.getDefaultCategory();
        this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.orderService.addSkuToOrder(order.getId(), newInactiveSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.orderService.addBundleItemToOrder(order, this.createBundleOrderItemRequest());
        this.orderService.addBundleItemToOrder(order, this.createBundleOrderItemRequestWithInactiveSku());
        return order;
    }

    public Order setUpExistingCartWithInactiveSkuAndInactiveBundle(Customer customer) throws PricingException {
        Sku newSku = this.addTestSku("Large Plastic Crate", "Plastic Crate", "Crates");
        Sku newInactiveSku = this.addTestSku("Large Red Plastic Crate", "Plastic Crate", "Crates", false);
        Product newProduct = (Product)newSku.getAllParentProducts().get(0);
        Category newCategory = newProduct.getDefaultCategory();
        Order order = this.cartService.createNewCartForCustomer(customer);
        this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.orderService.addSkuToOrder(order.getId(), newInactiveSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.orderService.addBundleItemToOrder(order, this.createBundleOrderItemRequest());
        this.orderService.addBundleItemToOrder(order, this.createBundleOrderItemRequestWithInactiveSku());
        return order;
    }

    public Order setUpExistingCart(Customer customer) throws PricingException {
        Sku newSku = this.addTestSku("Large Plastic Crate", "Plastic Crate", "Crates");
        Sku newOtherSku = this.addTestSku("Large Red Plastic Crate", "Plastic Crate", "Crates");
        Product newProduct = (Product)newSku.getAllParentProducts().get(0);
        Category newCategory = newProduct.getDefaultCategory();
        Order order = this.cartService.createNewCartForCustomer(customer);
        this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        this.orderService.addSkuToOrder(order.getId(), newOtherSku.getId(), newProduct.getId(), newCategory.getId(), Integer.valueOf(2));
        return order;
    }

    public BundleOrderItemRequest createBundleOrderItemRequest() {
        Sku screwSku = this.addTestSku("Screw", "Bookshelf", "Components");
        Sku shelfSku = this.addTestSku("Shelf", "Bookshelf", "Components");
        Sku bracketsSku = this.addTestSku("Brackets", "Bookshelf", "Components");
        Category category = ((Product)screwSku.getAllParentProducts().get(0)).getDefaultCategory();
        ArrayList<DiscreteOrderItemRequest> discreteOrderItems = new ArrayList<DiscreteOrderItemRequest>();
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(screwSku, 20));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(shelfSku, 3));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(bracketsSku, 6));
        BundleOrderItemRequest itemRequest = new BundleOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setName("test bundle " + this.bundleCount++);
        itemRequest.setQuantity(1);
        itemRequest.setDiscreteOrderItems(discreteOrderItems);
        return itemRequest;
    }

    public BundleOrderItemRequest createBundleOrderItemRequestWithInactiveSku() {
        Sku drawerSku = this.addTestSku("Drawer", "Drawer System", "Systems");
        Sku nailsSku = this.addTestSku("Nails", "Drawer System", "Systems");
        Sku tracksSku = this.addTestSku("Tracks", "Drawer System", "Systems", false);
        Category category = ((Product)drawerSku.getAllParentProducts().get(0)).getDefaultCategory();
        ArrayList<DiscreteOrderItemRequest> discreteOrderItems = new ArrayList<DiscreteOrderItemRequest>();
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(drawerSku, 20));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(nailsSku, 3));
        discreteOrderItems.add(this.createDiscreteOrderItemRequest(tracksSku, 6));
        BundleOrderItemRequest itemRequest = new BundleOrderItemRequest();
        itemRequest.setCategory(category);
        itemRequest.setName("test bundle " + this.bundleCount++);
        itemRequest.setQuantity(1);
        itemRequest.setDiscreteOrderItems(discreteOrderItems);
        return itemRequest;
    }

    public DiscreteOrderItemRequest createDiscreteOrderItemRequest(Sku sku, int quantity) {
        Product product = (Product)sku.getAllParentProducts().get(0);
        DiscreteOrderItemRequest request = new DiscreteOrderItemRequest();
        request.setSku(sku);
        request.setQuantity(quantity);
        request.setProduct(product);
        request.setCategory(product.getDefaultCategory());
        return request;
    }
}

