/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.order.FulfillmentGroupDataProvider;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderBaseTest;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.PaymentInfoDataProvider;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.pricing.ShippingRateDataProvider;
import org.broadleafcommerce.core.pricing.domain.ShippingRate;
import org.broadleafcommerce.core.pricing.service.ShippingRateService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class OrderTest
extends OrderBaseTest {
    private Long orderId = null;
    private int numOrderItems = 0;
    private Long fulfillmentGroupId;
    private Long bundleOrderItemId;
    @Resource
    private OrderItemService orderItemService;
    @Resource
    private SkuDao skuDao;
    @Resource
    private ShippingRateService shippingRateService;

    @Test(groups={"createCartForCustomer"}, dependsOnGroups={"readCustomer", "createPhone"})
    @Transactional
    @Rollback(value=false)
    public void createCartForCustomer() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.cartService.createNewCartForCustomer(customer);
        assert (order != null);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"findCurrentCartForCustomer"}, dependsOnGroups={"readCustomer", "createPhone", "createCartForCustomer"})
    @Transactional
    @Rollback(value=false)
    public void findCurrentCartForCustomer() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.cartService.findCartForCustomer(customer);
        assert (order != null);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"addItemToOrder"}, dependsOnGroups={"findCurrentCartForCustomer", "createSku"})
    @Rollback(value=false)
    @Transactional
    public void addItemToOrder() throws PricingException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.cartService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setQuantity(1);
        itemRequest.setSku(sku);
        DiscreteOrderItem item = (DiscreteOrderItem)this.cartService.addDiscreteItemToOrder(order, itemRequest);
        assert (item != null);
        assert (item.getQuantity() == this.numOrderItems);
        assert (item.getSku() != null);
        assert (item.getSku().equals(sku));
    }

    @Test(groups={"addAnotherItemToOrder"}, dependsOnGroups={"addItemToOrder"})
    @Rollback(value=false)
    @Transactional
    public void addAnotherItemToOrder() throws PricingException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setQuantity(1);
        itemRequest.setSku(sku);
        DiscreteOrderItem item = (DiscreteOrderItem)this.orderService.addDiscreteItemToOrder(order, itemRequest);
        assert (item != null);
        assert (item.getQuantity() == 1);
        assert (item.getSku() != null);
        assert (item.getSku().equals(sku));
        order = this.orderService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 2);
    }

    @Test(groups={"addBundleToOrder"}, dependsOnGroups={"addAnotherItemToOrder"})
    @Rollback(value=false)
    @Transactional
    public void addBundleToOrder() throws PricingException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        BundleOrderItemRequest bundleRequest = new BundleOrderItemRequest();
        bundleRequest.setQuantity(1);
        bundleRequest.setName("myBundle");
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setQuantity(1);
        itemRequest.setSku(sku);
        bundleRequest.getDiscreteOrderItems().add(itemRequest);
        BundleOrderItem item = (BundleOrderItem)this.orderService.addBundleItemToOrder(order, bundleRequest);
        this.bundleOrderItemId = item.getId();
        assert (item != null);
        assert (item.getQuantity() == 1);
    }

    @Test(groups={"removeBundleFromOrder"}, dependsOnGroups={"addBundleToOrder"})
    @Rollback(value=false)
    @Transactional
    public void removeBundleFromOrder() throws PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() == this.numOrderItems);
        int startingSize = orderItems.size();
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemService.readOrderItemById(this.bundleOrderItemId);
        assert (bundleOrderItem != null);
        assert (bundleOrderItem.getDiscreteOrderItems() != null);
        assert (bundleOrderItem.getDiscreteOrderItems().size() == 1);
        this.orderService.removeItemFromOrder(order, (OrderItem)bundleOrderItem);
        order = this.orderService.findOrderById(this.orderId);
        List items = order.getOrderItems();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"getItemsForOrder"}, dependsOnGroups={"removeBundleFromOrder"})
    @Transactional
    public void getItemsForOrder() {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems != null);
        assert (orderItems.size() == this.numOrderItems - 1);
    }

    @Test(groups={"updateItemsInOrder"}, dependsOnGroups={"getItemsForOrder"})
    @Transactional
    public void updateItemsInOrder() throws ItemNotFoundException, PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        OrderItem item = (OrderItem)orderItems.get(0);
        ((DiscreteOrderItem)item).getSku().setSalePrice(new Money(BigDecimal.valueOf(10000L)));
        item.setQuantity(10);
        this.orderService.updateItemQuantity(order, item);
        OrderItem updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getPrice().equals((Object)new Money(BigDecimal.valueOf(10000L))));
        assert (updatedItem.getQuantity() == 10);
        ArrayList updateItems = new ArrayList(order.getOrderItems());
        ((OrderItem)updateItems.get(0)).setQuantity(15);
        this.orderService.updateItemQuantity(order, updatedItem);
        order = this.orderService.findOrderById(this.orderId);
        assert (((OrderItem)order.getOrderItems().get(0)).getQuantity() == 15);
    }

    @Test(groups={"removeItemFromOrder"}, dependsOnGroups={"getItemsForOrder"})
    @Transactional
    public void removeItemFromOrder() throws PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        int startingSize = orderItems.size();
        OrderItem item = (OrderItem)orderItems.get(0);
        assert (item != null);
        this.orderService.removeItemFromOrder(order, item);
        order = this.orderService.findOrderById(this.orderId);
        List items = order.getOrderItems();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"checkOrderItems"}, dependsOnGroups={"removeItemFromOrder"})
    @Transactional
    public void checkOrderItems() throws PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 2);
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemService.readOrderItemById(this.bundleOrderItemId);
        assert (bundleOrderItem == null);
    }

    @Test(groups={"addPaymentToOrder"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class, dependsOnGroups={"checkOrderItems"})
    @Rollback(value=false)
    @Transactional
    public void addPaymentToOrder(PaymentInfo paymentInfo) {
        Order order = this.orderService.findOrderById(this.orderId);
        this.orderService.addPaymentToOrder(order, paymentInfo, null);
        order = this.orderService.findOrderById(this.orderId);
        PaymentInfo payment = (PaymentInfo)order.getPaymentInfos().get(order.getPaymentInfos().indexOf(paymentInfo));
        assert (payment != null);
        assert (payment.getOrder() != null);
        assert (payment.getOrder().equals(order));
    }

    @Test(groups={"addFulfillmentGroupToOrderFirst"}, dataProvider="basicFulfillmentGroup", dataProviderClass=FulfillmentGroupDataProvider.class, dependsOnGroups={"addPaymentToOrder"})
    @Rollback(value=false)
    @Transactional
    public void addFulfillmentGroupToOrderFirst(FulfillmentGroup fulfillmentGroup) throws PricingException {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Address address = ((CustomerAddress)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        Order order = this.orderService.findOrderById(this.orderId);
        fulfillmentGroup.setOrder(order);
        fulfillmentGroup.setAddress(address);
        FulfillmentGroup fg = this.orderService.addFulfillmentGroupToOrder(order, fulfillmentGroup);
        assert (fg != null);
        assert (fg.getId() != null);
        assert (fg.getAddress().equals(fulfillmentGroup.getAddress()));
        assert (fg.getOrder().equals(order));
        assert (fg.getMethod().equals(fulfillmentGroup.getMethod()));
        assert (fg.getReferenceNumber().equals(fulfillmentGroup.getReferenceNumber()));
        this.fulfillmentGroupId = fg.getId();
    }

    @Test(groups={"removeFulfillmentGroupFromOrder"}, dependsOnGroups={"addFulfillmentGroupToOrderFirst"})
    @Transactional
    public void removeFulfillmentGroupFromOrder() throws PricingException {
        Order order = this.orderService.findOrderById(this.orderId);
        List fgItems = order.getFulfillmentGroups();
        assert (fgItems.size() > 0);
        int startingSize = fgItems.size();
        FulfillmentGroup item = (FulfillmentGroup)fgItems.get(0);
        assert (item != null);
        this.orderService.removeFulfillmentGroupFromOrder(order, item);
        order = this.orderService.findOrderById(this.orderId);
        List items = order.getFulfillmentGroups();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"findFulFillmentGroupForOrderFirst"}, dependsOnGroups={"addFulfillmentGroupToOrderFirst"})
    @Transactional
    public void findFillmentGroupForOrderFirst() {
        Order order = this.orderService.findOrderById(this.orderId);
        FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg != null);
        assert (fg.getId() != null);
        FulfillmentGroup fulfillmentGroup = (FulfillmentGroup)this.em.find(FulfillmentGroupImpl.class, (Object)this.fulfillmentGroupId);
        assert (fg.getAddress().getId().equals(fulfillmentGroup.getAddress().getId()));
        assert (fg.getOrder().equals(order));
        assert (fg.getMethod().equals(fulfillmentGroup.getMethod()));
        assert (fg.getReferenceNumber().equals(fulfillmentGroup.getReferenceNumber()));
    }

    @Test(groups={"addItemToFulfillmentGroupSecond"}, dependsOnGroups={"addFulfillmentGroupToOrderFirst"})
    @Transactional
    public void addItemToFulfillmentgroupSecond() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Address address = ((CustomerAddress)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        FulfillmentGroupImpl newFg = new FulfillmentGroupImpl();
        newFg.setAddress(address);
        newFg.setMethod("standard");
        newFg.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        try {
            newFg = this.orderService.addItemToFulfillmentGroup((OrderItem)orderItems.get(0), (FulfillmentGroup)newFg, 1);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        order = this.orderService.findOrderById(this.orderId);
        FulfillmentGroup newNewFg = (FulfillmentGroup)order.getFulfillmentGroups().get(order.getFulfillmentGroups().indexOf(newFg));
        assert (newNewFg.getFulfillmentGroupItems().size() == 1);
        assert (((FulfillmentGroupItem)newNewFg.getFulfillmentGroupItems().get(0)).getOrderItem().equals(orderItems.get(0)));
    }

    @Test(groups={"findDefaultFulFillmentGroupForOrder"}, dependsOnGroups={"findCurrentCartForCustomer", "addFulfillmentGroupToOrderFirst"})
    @Transactional
    public void findDefaultFillmentGroupForOrder() {
        Order order = this.orderService.findOrderById(this.orderId);
        FulfillmentGroup fg = this.orderService.findDefaultFulfillmentGroupForOrder(order);
        assert (fg != null);
        assert (fg.getId() != null);
        FulfillmentGroup fulfillmentGroup = (FulfillmentGroup)this.em.find(FulfillmentGroupImpl.class, (Object)this.fulfillmentGroupId);
        assert (fg.getAddress().getId().equals(fulfillmentGroup.getAddress().getId()));
        assert (fg.getOrder().equals(order));
        assert (fg.getMethod().equals(fulfillmentGroup.getMethod()));
        assert (fg.getReferenceNumber().equals(fulfillmentGroup.getReferenceNumber()));
    }

    @Test(groups={"removeItemFromOrderAfterDefaultFulfillmentGroup"}, dependsOnGroups={"addFulfillmentGroupToOrderFirst"})
    @Transactional
    public void removeItemFromOrderAfterFulfillmentGroups() {
        Order order = this.orderService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        OrderItem item = (OrderItem)orderItems.get(0);
        assert (item != null);
        try {
            this.orderService.removeItemFromOrder(order, item);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        FulfillmentGroup fg = this.orderService.findDefaultFulfillmentGroupForOrder(order);
        for (FulfillmentGroupItem fulfillmentGroupItem : fg.getFulfillmentGroupItems()) {
            assert (!fulfillmentGroupItem.getOrderItem().equals(item));
        }
    }

    @Test(groups={"getOrdersForCustomer"}, dependsOnGroups={"readCustomer", "findCurrentCartForCustomer"})
    @Transactional
    public void getOrdersForCustomer() {
        String username = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(username);
        List orders = this.orderService.findOrdersForCustomer(customer);
        assert (orders != null);
        assert (orders.size() > 0);
    }

    @Test(groups={"findCartForAnonymousCustomer"}, dependsOnGroups={"getOrdersForCustomer"})
    public void findCartForAnonymousCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.findCartForCustomer(customer);
        assert (order == null);
        order = this.cartService.createNewCartForCustomer(customer);
        Long orderId = order.getId();
        Order newOrder = this.orderService.findOrderById(orderId);
        assert (newOrder != null);
        assert (newOrder.getCustomer() != null);
    }

    @Test(groups={"findOrderByOrderNumber"}, dependsOnGroups={"findCartForAnonymousCustomer"})
    @Transactional
    public void findOrderByOrderNumber() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setOrderNumber("3456");
        order = this.orderService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order newOrder = this.orderService.findOrderByOrderNumber("3456");
        assert (newOrder.getId().equals(orderId));
        Order nullOrder = this.orderService.findOrderByOrderNumber(null);
        assert (nullOrder == null);
        nullOrder = this.orderService.findOrderByOrderNumber("");
        assert (nullOrder == null);
    }

    @Test(groups={"findNamedOrderForCustomer"}, dependsOnGroups={"findOrderByOrderNumber"})
    @Transactional
    public void findNamedOrderForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.NAMED);
        order.setName("COOL ORDER");
        order = this.orderService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order newOrder = this.orderService.findNamedOrderForCustomer("COOL ORDER", customer);
        assert (newOrder.getId().equals(orderId));
    }

    @Test(groups={"testReadOrdersForCustomer"}, dependsOnGroups={"findNamedOrderForCustomer"})
    @Transactional
    public void testReadOrdersForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.orderService.save(order, Boolean.valueOf(false));
        List newOrders = this.orderService.findOrdersForCustomer(customer, OrderStatus.IN_PROCESS);
        boolean containsOrder = false;
        if (newOrders.contains(order)) {
            containsOrder = true;
        }
        assert (containsOrder);
        containsOrder = false;
        newOrders = this.orderService.findOrdersForCustomer(customer, null);
        if (newOrders.contains(order)) {
            containsOrder = true;
        }
        assert (containsOrder);
    }

    @Test(groups={"testOrderProperties"}, dependsOnGroups={"testReadOrdersForCustomer"})
    public void testOrderProperties() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        assert (order.getSubTotal() == null);
        assert (order.getTotal() == null);
        assert (order.getRemainingTotal() == null);
        Calendar testCalendar = Calendar.getInstance();
        order.setSubmitDate(testCalendar.getTime());
        assert (order.getSubmitDate().equals(testCalendar.getTime()));
    }

    @Test(groups={"testNamedOrderForCustomer"}, dependsOnGroups={"testOrderProperties"})
    public void testNamedOrderForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer = this.customerService.saveCustomer(customer);
        Order order = this.orderService.createNamedOrderForCustomer("Birthday Order", customer);
        Long orderId = order.getId();
        assert (order != null);
        assert (order.getName().equals("Birthday Order"));
        assert (order.getCustomer().equals(customer));
        this.orderService.removeNamedOrderForCustomer("Birthday Order", customer);
        assert (this.orderService.findOrderById(orderId) == null);
    }

    @Test(groups={"testAddSkuToOrder"})
    @Transactional
    public void testAddSkuToOrder() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.customerService.createCustomerFromId(null));
        CategoryImpl category = new CategoryImpl();
        category.setName("Pants");
        category = this.catalogService.saveCategory((Category)category);
        ProductImpl newProduct = new ProductImpl();
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        newProduct.setActiveStartDate(activeStartCal.getTime());
        newProduct.setDefaultCategory((Category)category);
        newProduct.setName("Leather Pants");
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        SkuImpl newSku = new SkuImpl();
        newSku.setName("Red Leather Pants");
        newSku.setRetailPrice(new Money(44.99));
        newSku.setActiveStartDate(activeStartCal.getTime());
        newSku.setDiscountable(Boolean.valueOf(true));
        newSku = this.catalogService.saveSku((Sku)newSku);
        ArrayList<SkuImpl> allSkus = new ArrayList<SkuImpl>();
        allSkus.add(newSku);
        newProduct.setAllSkus(allSkus);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Order order = this.orderService.createNamedOrderForCustomer("Pants Order", customer);
        OrderItem orderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem quantityNullOrderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), category.getId(), null);
        OrderItem skuNullOrderItem = this.orderService.addSkuToOrder(order.getId(), null, newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem orderNullOrderItem = this.orderService.addSkuToOrder(null, newSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem productNullOrderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), null, category.getId(), Integer.valueOf(2));
        OrderItem categoryNullOrderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), null, Integer.valueOf(2));
        assert (orderItem != null);
        assert (skuNullOrderItem == null);
        assert (quantityNullOrderItem == null);
        assert (orderNullOrderItem == null);
        assert (productNullOrderItem != null);
        assert (categoryNullOrderItem != null);
    }

    @Test(groups={"testOrderPaymentInfos"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class)
    @Transactional
    public void testOrderPaymentInfos(PaymentInfo info) throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        this.orderService.addPaymentToOrder(order, info);
        boolean foundInfo = false;
        assert (order.getPaymentInfos() != null);
        for (PaymentInfo testInfo : order.getPaymentInfos()) {
            if (!testInfo.equals(info)) continue;
            foundInfo = true;
        }
        assert (foundInfo);
        assert (this.orderService.readPaymentInfosForOrder(order) != null);
    }

    @Test(groups={"testSubmitOrder"}, dependsOnGroups={"findNamedOrderForCustomer"})
    public void testSubmitOrder() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.orderService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order confirmedOrder = this.orderService.confirmOrder(order);
        confirmedOrder = this.orderService.findOrderById(confirmedOrder.getId());
        Long confirmedOrderId = confirmedOrder.getId();
        assert (orderId.equals(confirmedOrderId));
        assert (confirmedOrder.getStatus().equals((Object)OrderStatus.SUBMITTED));
    }

    @Test
    public void findCartForNullCustomerId() {
        assert (this.cartService.findCartForCustomer((Customer)new CustomerImpl()) == null);
    }

    @Test(groups={"testCartAndNamedOrder"})
    @Transactional
    public void testCreateNamedOrder() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.customerService.createCustomerFromId(null));
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        CategoryImpl category = new CategoryImpl();
        category.setName("Pants");
        category.setActiveStartDate(activeStartCal.getTime());
        category = this.catalogService.saveCategory((Category)category);
        ProductImpl newProduct = new ProductImpl();
        newProduct.setActiveStartDate(activeStartCal.getTime());
        newProduct.setDefaultCategory((Category)category);
        newProduct.setName("Leather Pants");
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        SkuImpl newSku = new SkuImpl();
        newSku.setName("Red Leather Pants");
        newSku.setRetailPrice(new Money(44.99));
        newSku.setActiveStartDate(activeStartCal.getTime());
        newSku.setDiscountable(Boolean.valueOf(true));
        newSku = this.catalogService.saveSku((Sku)newSku);
        ArrayList<SkuImpl> allSkus = new ArrayList<SkuImpl>();
        allSkus.add(newSku);
        newProduct.setAllSkus(allSkus);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Order order = this.orderService.createNamedOrderForCustomer("Pants Order", customer);
        OrderItem orderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem quantityNullOrderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), category.getId(), null);
        OrderItem skuNullOrderItem = this.orderService.addSkuToOrder(order.getId(), null, newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem orderNullOrderItem = this.orderService.addSkuToOrder(null, newSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem productNullOrderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), null, category.getId(), Integer.valueOf(2));
        OrderItem categoryNullOrderItem = this.orderService.addSkuToOrder(order.getId(), newSku.getId(), newProduct.getId(), null, Integer.valueOf(2));
        assert (orderItem != null);
        assert (skuNullOrderItem == null);
        assert (quantityNullOrderItem == null);
        assert (orderNullOrderItem == null);
        assert (productNullOrderItem != null);
        assert (categoryNullOrderItem != null);
    }

    @Test(groups={"testOrderFulfillmentGroups"}, dataProvider="basicShippingRates", dataProviderClass=ShippingRateDataProvider.class)
    @Transactional
    public void testAddFulfillmentGroupToOrder(ShippingRate shippingRate, ShippingRate sr2) throws PricingException, ItemNotFoundException {
        shippingRate = this.shippingRateService.save(shippingRate);
        sr2 = this.shippingRateService.save(sr2);
        Customer customer = this.createCustomerWithAddresses();
        Order order = this.setUpExistingCart(customer);
        CustomerAddress customerAddress = (CustomerAddress)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0);
        FulfillmentGroupRequest fgRequest = new FulfillmentGroupRequest();
        ArrayList<FulfillmentGroupItemRequest> fgiRequests = new ArrayList<FulfillmentGroupItemRequest>();
        for (OrderItem orderItem : order.getOrderItems()) {
            FulfillmentGroupItemRequest fgiRequest = new FulfillmentGroupItemRequest();
            fgiRequest.setOrderItem(orderItem);
            fgiRequest.setQuantity(1);
            fgiRequests.add(fgiRequest);
        }
        fgRequest.setAddress(customerAddress.getAddress());
        fgRequest.setFulfillmentGroupItemRequests(fgiRequests);
        fgRequest.setOrder(this.cartService.findCartForCustomer(customer));
        fgRequest.setMethod("standard");
        fgRequest.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        this.orderService.addFulfillmentGroupToOrder(fgRequest);
        Order resultOrder = this.orderService.findOrderById(order.getId());
        assert (resultOrder.getFulfillmentGroups().size() == 1);
        assert (((FulfillmentGroup)resultOrder.getFulfillmentGroups().get(0)).getFulfillmentGroupItems().size() == 2);
        this.orderService.removeAllFulfillmentGroupsFromOrder(order, false);
        resultOrder = this.orderService.findOrderById(order.getId());
        assert (resultOrder.getFulfillmentGroups().size() == 0);
        FulfillmentGroup defaultFg = this.orderService.createDefaultFulfillmentGroup(order, customerAddress.getAddress());
        defaultFg.setMethod("standard");
        defaultFg.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        assert (defaultFg.isPrimary());
        this.orderService.addFulfillmentGroupToOrder(order, defaultFg);
        resultOrder = this.orderService.findOrderById(order.getId());
        assert (resultOrder.getFulfillmentGroups().size() == 1);
    }
}

