/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.domain.ShippingRate;
import org.broadleafcommerce.core.pricing.domain.ShippingRateImpl;
import org.broadleafcommerce.core.pricing.service.ShippingRateService;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.CustomerAddressImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.test.BaseTest;

public abstract class CommonSetupBaseTest
extends BaseTest {
    @Resource
    protected CountryService countryService;
    @Resource
    protected StateService stateService;
    @Resource
    protected CustomerService customerService;
    @Resource
    protected CustomerAddressService customerAddressService;
    @Resource
    protected CatalogService catalogService;
    @Resource
    protected OrderService orderService;
    @Resource
    protected ShippingRateService shippingRateService;
    @Resource
    private OrderDao orderDao;

    public void createCountry() {
        CountryImpl country = new CountryImpl();
        country.setAbbreviation("US");
        country.setName("United States");
        this.countryService.save((Country)country);
    }

    public void createState() {
        StateImpl state = new StateImpl();
        state.setAbbreviation("KY");
        state.setName("Kentucky");
        state.setCountry(this.countryService.findCountryByAbbreviation("US"));
        this.stateService.save((State)state);
    }

    public Customer createCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        return customer;
    }

    public Customer createCustomerWithAddresses() {
        this.createCountry();
        this.createState();
        CustomerAddressImpl ca1 = new CustomerAddressImpl();
        AddressImpl address1 = new AddressImpl();
        address1.setAddressLine1("1234 Merit Drive");
        address1.setCity("Bozeman");
        address1.setPostalCode("75251");
        ca1.setAddress((Address)address1);
        ca1.setAddressName("address1");
        CustomerAddress caResult = this.createCustomerWithAddress((CustomerAddress)ca1);
        assert (caResult != null);
        assert (caResult.getCustomer() != null);
        Customer customer = caResult.getCustomer();
        CustomerAddressImpl ca2 = new CustomerAddressImpl();
        AddressImpl address2 = new AddressImpl();
        address2.setAddressLine1("12 Testing Drive");
        address2.setCity("Portland");
        address2.setPostalCode("75251");
        ca2.setAddress((Address)address2);
        ca2.setAddressName("address2");
        ca2.setCustomer(customer);
        CustomerAddress addResult = this.saveCustomerAddress((CustomerAddress)ca2);
        assert (addResult != null);
        return customer;
    }

    public CustomerAddress createCustomerWithAddress(CustomerAddress customerAddress) {
        this.createCountry();
        this.createState();
        Customer customer = this.createCustomer();
        customer.setUsername(String.valueOf(customer.getId()));
        customerAddress.setCustomer(customer);
        return this.saveCustomerAddress(customerAddress);
    }

    public CustomerAddress saveCustomerAddress(CustomerAddress customerAddress) {
        State state = this.stateService.findStateByAbbreviation("KY");
        customerAddress.getAddress().setState(state);
        Country country = this.countryService.findCountryByAbbreviation("US");
        customerAddress.getAddress().setCountry(country);
        return this.customerAddressService.saveCustomerAddress(customerAddress);
    }

    public Customer createCustomerWithBasicOrderAndAddresses() {
        Customer customer = this.createCustomerWithAddresses();
        OrderImpl order = new OrderImpl();
        order.setStatus(OrderStatus.IN_PROCESS);
        order.setTotal(new Money(BigDecimal.valueOf(1000L)));
        assert (order.getId() == null);
        order.setCustomer(customer);
        order = this.orderDao.save((Order)order);
        assert (order.getId() != null);
        return customer;
    }

    public Sku addTestSku(String skuName, String productName, String categoryName) {
        return this.addTestSku(skuName, productName, categoryName, true);
    }

    public Sku addTestSku(String skuName, String productName, String categoryName, boolean active) {
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        CategoryImpl category = new CategoryImpl();
        category.setName(categoryName);
        category.setActiveStartDate(activeStartCal.getTime());
        category = this.catalogService.saveCategory((Category)category);
        ProductImpl newProduct = new ProductImpl();
        Calendar activeEndCal = Calendar.getInstance();
        activeEndCal.add(6, -1);
        newProduct.setActiveStartDate(activeStartCal.getTime());
        newProduct.setDefaultCategory((Category)category);
        newProduct.setName(productName);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        ArrayList<ProductImpl> products = new ArrayList<ProductImpl>();
        products.add(newProduct);
        SkuImpl newSku = new SkuImpl();
        newSku.setName(skuName);
        newSku.setRetailPrice(new Money(44.99));
        newSku.setActiveStartDate(activeStartCal.getTime());
        if (!active) {
            newSku.setActiveEndDate(activeEndCal.getTime());
        }
        newSku.setDiscountable(Boolean.valueOf(true));
        newSku = this.catalogService.saveSku((Sku)newSku);
        newSku.setAllParentProducts(products);
        ArrayList<SkuImpl> allSkus = new ArrayList<SkuImpl>();
        allSkus.add(newSku);
        newProduct.setAllSkus(allSkus);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        return newSku;
    }

    public void createShippingRates() {
        ShippingRateImpl sr = new ShippingRateImpl();
        sr.setFeeType("SHIPPING");
        sr.setFeeSubType("ALL");
        sr.setFeeBand(Integer.valueOf(1));
        sr.setBandUnitQuantity(BigDecimal.valueOf(29.99));
        sr.setBandResultQuantity(BigDecimal.valueOf(8.5));
        sr.setBandResultPercent(Integer.valueOf(0));
        ShippingRateImpl sr2 = new ShippingRateImpl();
        sr2.setFeeType("SHIPPING");
        sr2.setFeeSubType("ALL");
        sr2.setFeeBand(Integer.valueOf(2));
        sr2.setBandUnitQuantity(BigDecimal.valueOf(999999.99));
        sr2.setBandResultQuantity(BigDecimal.valueOf(8.5));
        sr2.setBandResultPercent(Integer.valueOf(0));
        this.shippingRateService.save((ShippingRate)sr);
        this.shippingRateService.save((ShippingRate)sr2);
    }
}

