/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.ArrayList;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.CategoryDaoDataProvider;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.FeaturedProduct;
import org.broadleafcommerce.core.catalog.domain.FeaturedProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class CategoryDaoTest
extends BaseTest {
    @Resource
    private CategoryDao categoryDao;
    @Resource
    private CatalogService catalogService;

    @Test(groups={"testSetFeaturedProducts"}, dataProvider="basicCategory", dataProviderClass=CategoryDaoDataProvider.class)
    @Transactional
    public void testSetFeaturedProducts(Category category) {
        category = this.catalogService.saveCategory(category);
        ProductImpl product = new ProductImpl();
        product.setModel("KGX200");
        product.setDescription("This thing will change your life");
        product.setName("Test Product");
        product = this.catalogService.saveProduct((Product)product);
        FeaturedProductImpl featuredProduct = new FeaturedProductImpl();
        featuredProduct.setCategory(category);
        featuredProduct.setProduct((Product)product);
        featuredProduct.setPromotionMessage("BUY ME NOW!!!!");
        ArrayList<FeaturedProductImpl> featuredProducts = new ArrayList<FeaturedProductImpl>();
        featuredProducts.add(featuredProduct);
        category.setFeaturedProducts(featuredProducts);
        category = this.catalogService.saveCategory(category);
        Category categoryTest = this.categoryDao.readCategoryById(category.getId());
        FeaturedProduct featuredProductTest = (FeaturedProduct)categoryTest.getFeaturedProducts().get(0);
        assert (featuredProductTest.getPromotionMessage() == "BUY ME NOW!!!!");
        assert (featuredProductTest.getProduct().getModel().equals("KGX200"));
    }
}

